from azure.mgmt.storage.v2016_12_01.models import StorageAccount
from msrestazure.azure_exceptions import CloudError
from xld.azure import wait_for_success_provisioning

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
storage_client = connector.storage_client()

storage_account_name = deployed.storageAccountName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

try:
    # synchronous
    op_result = storage_client.storage_accounts.get_properties(
        resource_group_name=resource_group_name,
        account_name=storage_account_name
    )
except CloudError as e:
    # An operation is currently performing on this storage account that requires exclusive access.
    in_progress = 'StorageAccountOperationInProgress'
    if e.error.error in [in_progress]:
        op_result = StorageAccount()
        op_result.provisioning_state = in_progress
    else:
        raise

logger.info("Result: {0}".format(op_result))

result = wait_for_success_provisioning(op_result, storage_account_name)

if result == "SUCCESS":
    storage_keys = storage_client.storage_accounts.list_keys(resource_group_name, storage_account_name)
    storage_keys = {v.key_name: v.value for v in storage_keys.keys}

    deployed.key1 = storage_keys['key1']
    deployed.key2 = storage_keys['key2']
