import xml.etree.ElementTree as ET
import requests

from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = previousDeployed.webAppName
site_extension_id = previousDeployed.siteExtensionID

print "Undeploying Web App Extension {0} from Web App {1} under Resource Group {2}".format(site_extension_id, web_app_name, resource_group_name)

# synchronous
credentials = web_client.web_apps.list_publishing_profile_xml_with_secrets(
    resource_group_name = resource_group_name,
    name = web_app_name,
    format = 'Ftp'
)

#Parse credentials from XML
root = ET.XML(''.join(credentials))
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

api_url = "https://" + web_app_name + ".scm.azurewebsites.net/api/siteextensions/" + site_extension_id

r = requests.delete(
    url = api_url,
    auth = (api_username, api_password)
)

logger.info("Result: {0}".format(r))

if r.status_code == 200:
    print "Web App Extension undeployed successfully."
elif r.status_code == 404:
    raise RuntimeError("Site Extension not found. Please check the site extension id.")
