import xml.etree.ElementTree as ET
import requests
import json

from xld.azure.connector import AzureConnector

rg = deployed.container
clean_space = deployed.cleanTgtSpace
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

web_app_name = deployed.webAppName
resource_group_name = rg.resourceGroupName or rg.name

# retrieve scm endpoint
get_webapp_url = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/sites/{2}?api-version=2022-03-01".format(connector.subscription_id, resource_group_name, web_app_name)
token = "Bearer " + connector.credentials.token['access_token']
headers = {
    "Content-type": "application/json",
    "Authorization": token
}
webapp_response = requests.get(url=get_webapp_url, headers=headers, proxies=connector.proxiesdict)
enabledHostNames = []
try:
    response_obj = json.loads(webapp_response.content)
    enabledHostNames = response_obj['properties']['enabledHostNames']

    scm_hostname = None
    for hostname in enabledHostNames:
        try:
            if ".scm." in hostname:
                scm_hostname = hostname
                print "SCM HostName identified %s" % scm_hostname
                break
        except:
            print "Failed to identify SCM HostName"
            logger.error("Failed to extract scm endpoint")
except:
    logger.info("Error retrieving webapp details {0}".format(web_app_name))
    print response_obj

publishing_cred_url = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/sites/{2}/publishxml?api-version=2022-03-01".format(connector.subscription_id, resource_group_name, web_app_name)
token = "Bearer " + connector.credentials.token['access_token']
headers = {
    "Content-type": "application/json",
    "Authorization": token
}
req_body = json.dumps({"format": "Ftp"})

r1 = requests.post(url=publishing_cred_url, headers=headers, data=req_body, proxies=connector.proxiesdict)
print("Retrieving publishing credentials status_code {0}".format(r1.status_code))
if not r1.ok:
    print "Failed to retrieve publishing credentials for webapp reason:%s" % r1.reason
    raise Exception("Failed to retrieve publishing credentials for webapp %s" % web_app_name)

response_xml = r1.text
print "Uploading Function App artifact {0} under Resource Group {1}".format(web_app_name, resource_group_name)
root = ET.XML(response_xml)
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

file_path = deployed.file.path
if deployed.artifactType:
    type=deployed.artifactType
else:
    type="zip"
    if file_path.endswith(".war"):
        type="war"
    elif file_path.endswith(".jar"):
        type="jar"
    elif file_path.endswith(".ear"):
        type="ear"

if scm_hostname:
    upload_url = "https://{0}/api/publish?type={1}&clean={2}".format(scm_hostname, type, clean_space)
else:
    upload_url = "https://{0}.scm.azurewebsites.net/api/publish?type={1}&clean={2}".format(web_app_name, type, clean_space)

if deployed.targetPath:
    upload_url = '%s&path="%s"' % (upload_url, deployed.targetPath)

print("upload url:%s" % upload_url)
files = open(deployed.file.path, 'rb')

verificationCertificateFilePath = None

if deployed.verifySSL and rg.certificateFile:
    verificationCertificateFilePath = rg.certificateFile.getFile().getPath()
if verificationCertificateFilePath:
    r = requests.post(url=upload_url, data=files, auth=(api_username, api_password), proxies=connector.proxiesdict, verify=verificationCertificateFilePath)
else:
    r = requests.post(url=upload_url, data=files, auth=(api_username, api_password), proxies=connector.proxiesdict, verify=False)

if not r.ok:
    print "Failed to upload artifact for webapp reason:%s" % r1.reason
    raise Exception("Failed to upload artifact for webapp %s" % web_app_name)
else:
    print "Artifact for webapp {0} uploaded under Resource Group {1}".format(web_app_name, resource_group_name)


logger.info("Result: {0}".format(r))
