from xld.azure.AzurePythonHelper import AzurePyHelper

cloud = deployed.container
azure_helper = AzurePyHelper(cloud)

deploymentName = deployed.deploymentName
resourceGroupName = deployed.resourceGroupName

if not deploymentName or not deploymentName.strip():
    raise Exception("ARM Template '%s' must have its 'Deployment Name' set" % deployed.name)

output = azure_helper.get_deployment_output(deploymentName, resourceGroupName)
output_variables = {}
if output:
    for k, v in output.items():
        print("Setting output variable '%s' to '%s'" % (k, '%s' % v['value']))
        output_variables[k] = '%s' % v['value']

deployed.outputVariables = output_variables

