import os
import subprocess
from subprocess import Popen, PIPE


def execute_command(command_group, command):
    process = subprocess.Popen(command, stdout=PIPE, stderr=PIPE, shell=True)
    stdout, stderr = process.communicate()
    return_code = process.returncode
    print("response code %s" % return_code)

    if return_code != 0:
        error = stderr
        raise Exception("Execution failed for {} with error : {}".format(command_group, error))
    else:
        response_str = stdout
        return return_code


feed = deployed.container
cloud = feed.container

project_name = feed.projectName
scope = feed.scope

# login using credentials
login_command = "az login -u " + cloud.userName + " -p \"" + cloud.userPassword + "\""

execute_command("az login", login_command)
print("Logged in successfully")

# install devops extension if not available
extension_command = "az extension add -n azure-devops"
execute_command("az add extension", extension_command)
print("Devops Extension added successfully")

# publish atrifact to feed

abs_path = os.path.abspath(deployed.file.path)

if scope == 'project':
    upload_command = "az artifacts universal publish --feed {} --name {} --path {} --version {} --organization {} --project {} --scope {}"
    upload_command = upload_command.format(feed.feedName, deployed.packageName, abs_path, deployed.packageVersion, feed.organizationUrl, project_name, scope)
else:
    upload_command = "az artifacts universal publish --feed {} --name {} --path {} --version {} --organization {} --scope {}"
    upload_command = upload_command.format(feed.feedName, deployed.packageName, abs_path, deployed.packageVersion, feed.organizationUrl, scope)
    
print(upload_command)
execute_command("az artifacts", upload_command)
print("atrifact uploaded successfully")