import json
import xml.etree.ElementTree as ET
import requests

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = deployed.webAppName
web_job_name = deployed.webJobName or deployed.name


print "Deploying Web Job artifact {0} to Web App {1} under Resource Group {2}".format(web_job_name, web_app_name,  resource_group_name)

# synchronous
credentials = web_client.web_apps.list_publishing_profile_xml_with_secrets(
    resource_group_name=resource_group_name,
    name=web_app_name,
    format='Ftp'
)

#Parse credentials from XML
root = ET.XML(''.join(credentials))
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

api_url="https://" + web_app_name + ".scm.azurewebsites.net/api/" + deployed.jobType + "/" + web_job_name

proxies=None
if connector.proxiesdict:
    proxies = json.dumps(connector.proxiesdict)

authorization = connector.httpRequestHelper.getBasicAuthenticationHeader(api_username,api_password)

headers = { "Content-Type": "application/zip", "Authorization": authorization,
            "Content-Disposition": "attachement; filename={0}".format(deployed.executableFileName) }

r = connector.httpRequestHelper.executeRequest(headers,"PUT",json.dumps(headers),None,deployed.file.path)

logger.info("Result: {0}".format(r['response']))

if deployed.jobType == "continuouswebjobs":
    if deployed.isSingleton == True:
        singletonString = "true"
    else:
        singletonString = "false"
    body = json.dumps({"is_singleton": singletonString})

elif deployed.jobType == "triggeredwebjobs":
    if deployed.schedule:
        body = json.dumps({"schedule": deployed.schedule})

api_url="https://" + web_app_name + ".scm.azurewebsites.net/api/" + deployed.jobType + "/" + web_job_name + "/settings"

headers={ "Content-Type": "application/json" , "Authorization": authorization}

response = connector.httpRequestHelper.executeRequest(api_url,"PUT",json.dumps(headers),body,None)

logger.info("Result: {0}".format(response['response']))
