from com.xebialabs.deployit.plugin.azure import AppServicePlanClient
from xld.azure.AzurePythonHelper import AzurePyHelper

rg = deployed.container
cloud = rg.container
service_plan_name = deployed.servicePlanName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

print("Creating AppServicePlan {0} under ResourceGroup {1}".format(service_plan_name, resource_group_name))

azure_helper = AzurePyHelper(cloud)

url = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/serverfarms/{2}?api-version=2023-12-01"\
    .format(cloud.subscriptionId, resource_group_name, service_plan_name)

reserved = 'false'
if deployed.osType == 'Linux':
    reserved = 'true'

req_body = {
    "location": deployed.location,
    "sku": {
        "capacity": deployed.skuCapacity,
        "family": deployed.skuFamily,
        "name": deployed.skuName,
        "size": deployed.skuSize,
        "tier": deployed.skuTier,
    },
    "properties": {
        "reserved": reserved
    }
}

azure_helper.create_app_service_plan(url, req_body)
