import requests
import json

from xld.azure.connector import AzureConnector

cloud = previousDeployed.container
connector = AzureConnector(cloud)

org_url = previousDeployed.organizationUrl
project_name = previousDeployed.projectName
scope = previousDeployed.scope

if org_url.endswith('/'):
    org_url = my_str = org_url[:-1]

org_name = org_url.rsplit('/', 1)[-1]

token = "Bearer " + connector.credentials.token['access_token']

if scope == 'project':
    delete_feed = "https://feeds.dev.azure.com/" + org_name + "/" + project_name + "/_apis/packaging/feeds/" + previousDeployed.feedName + "?api-version=6.0-preview.1"
else:
    delete_feed = "https://feeds.dev.azure.com/" + org_name + "/_apis/packaging/feeds/" + previousDeployed.feedName + "?api-version=6.0-preview.1"

headers = {
    "Content-type": "application/json",
    "Authorization": token
}

r = connector.get_requests_session().delete(url=delete_feed, headers=headers, verify=cloud.verifySSL)

print("status_code {0}".format(r.status_code))
print("text {0}".format(r.text))

if r.status_code != 204:
    raise Exception('Delete feed failed')
    return
