import requests
from xld.azure.connector import AzureConnector

cloud = previousDeployed.container
connector = AzureConnector(cloud)
subscription_id = previousDeployed.container.subscriptionId
resource_group_name = previousDeployed.resourceGroupName or previousDeployed.name

logger.info("Checking existence of {0} under SubscriptionId {1}".format(resource_group_name, subscription_id))

resource_group_name = previousDeployed.resourceGroupName or previousDeployed.name
url = "https://management.azure.com/subscriptions/{}/resourcegroups/{}?api-version=2021-04-01".format(previousDeployed.container.subscriptionId,resource_group_name)
headers = {'Content-Type': 'application/json','Authorization': 'Bearer ' + connector.credentials.token['access_token']}
response = connector.get_requests_session().head(url,headers=headers, proxies=connector.proxiesdict, verify=cloud.verifySSL)
is_group_present = True
if(response.status_code == 204):
    is_group_present = True
if(response.status_code == 404):
    is_group_present = False
    print "Resource Group {0} deleted.".format(resource_group_name)

logger.info("Resource is present: {0}".format(is_group_present))

if is_group_present:
    print "Waiting for {0} to be completely destroyed".format(resource_group_name)
    result = "RETRY"
