import time
from xld.azure.AzurePythonHelper import AzurePyHelper

azure_helper = AzurePyHelper(deployed.container)

deploymentName = deployed.deploymentName
resourceGroupName = deployed.resourceGroupName

if not deploymentName or not deploymentName.strip():
    raise Exception("Template '%s' must have its 'Deployment Name' set" % deployed.name)

retry_count = 0
sleep_interval = 5
last_activity_log_id = None
while True:
    retry_count += 1
    if retry_count > deployed.maxRetries:
        raise Exception("Deployment '%s' timed out waiting for 'Succeeded'." % deploymentName)

    state = azure_helper.get_deployment_state(deploymentName, resourceGroupName)
    if state:
        if state.lower() == 'failed':
            failureMessages = azure_helper.get_failed_deployment_operations(deploymentName, resourceGroupName)
            print failureMessages
            raise Exception("Deployment '%s' failed" % deploymentName)
        if state.lower() != 'running' and state.lower() != 'accepted':
            print("Final deployment state is '%s'" % state)
            break
        print("Current state is '%s'. Waiting 5 seconds." % state)
    else:
        print("Deployment '%s' does not exist yet" % deploymentName)
    time.sleep(sleep_interval)
