import sys
import os
import requests
import json
from xld.azure.connector import AzureConnector
from xld.azure import get_operation_name
from requests.exceptions import RequestException

cloud = deployed.container
connector = AzureConnector(cloud)
resource_group_name = deployed.resourceGroupName or deployed.name
resource_group_region = deployed.location

print "{0} Resource Group {1} under SubscriptionId {2}".format(
    get_operation_name(previousDeployed),
    resource_group_name,
    connector.subscription_id)

if previousDeployed:
    previousRGName = previousDeployed.resourceGroupName
    previousRegion = previousDeployed.location
    if previousRGName != "" and previousRGName != resource_group_name:
        errorMEssage = "Resource group name is not allowed to change on update ({0} -> {1})".format(previousRGName,resource_group_name)
        print(errorMEssage)
        sys.exit(errorMEssage)
    elif previousRegion != "" and previousRegion != resource_group_region:
        errorMessage = "Location is not allowed to change on update ({0} -> {1})!)".format(previousRegion,resource_group_region)
        print(errorMessage)
        sys.exit(errorMessage)
url = "https://management.azure.com/subscriptions/{}/resourcegroups/{}?api-version=2021-04-01".format(deployed.container.subscriptionId,resource_group_name)
body_data = {'location': deployed.location,'tags': deployed.resourceGroupTags}
json_body_data = json.dumps(body_data)
headers = {'Content-Type': 'application/json','Authorization': 'Bearer ' + connector.credentials.token['access_token']}
try:
    response = connector.get_requests_session().put(url, data=json_body_data, headers=headers, proxies=connector.proxiesdict, verify=cloud.verifySSL)
    logger.info("Resource is Created: {0}".format(resource_group_name))
    print "Resource Group {0} created/updated.".format(resource_group_name)
    #print response
    if not response.ok:
        print response.status_code
        print response.reason
        raise Exception("Error creating Resource Group")
except RequestException as e:
    print(e)
    raise Exception("Error creating Resource Group", e)
