from xld.azure.connector import AzureConnector
from xld.azure.AzurePythonHelper import AzurePyHelper
import json

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
azure_helper = AzurePyHelper(cloud)

web_app_name = deployed.webAppName
if deployed.deploymentId:
    deployment_id =deployed.deploymentId
    resource_group_name = rg.resourceGroupName or rg.name

    deployment_status_url = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/sites/{2}/deployments/{3}?api-version=2022-03-01"\
        .format(connector.subscription_id, resource_group_name, web_app_name, deployment_id)
    token = "Bearer " + connector.credentials.token['access_token']
    headers = {
        "Content-type": "application/json",
        "Authorization": token
    }

    deployment_response = connector.httpRequestHelper.executeRequest(deployment_status_url,"GET",json.dumps(headers),None,None)
    if not int(deployment_response['statusCode']) < 300:
        print "Failed to retrieve deployment of webapp %s for reason:%s" % (web_app_name, deployment_response['response'])
        raise Exception("Failed to retrieve deployment of webapp %s." % web_app_name)

    response_obj = json.loads(deployment_response['response'])
    status_code = response_obj['properties']['status']
    status = azure_helper.get_deployment_status(status_code)

    print("deployment status: %s" % status)
    if int(deployed.statusCheckRetryCounter) == 0:
        print("deployment url: %s" % response_obj['properties']['url'])
        print("log url: %s" % response_obj['properties']['log_url'])

    if status_code == 2:
        if int(deployed.statusCheckRetryCounter) < 100:
            result = "RETRY"
            deployed.statusCheckRetryCounter = deployed.statusCheckRetryCounter + 1
        else:
            raise Exception("Exhausted waiting for deployment to complete for Webapp %s" % web_app_name)

    elif status_code == 4:
        print ("Deployment complete")
    else:
        raise Exception("Deployment incomplete|failed for Webapp %s" % web_app_name)
else:
    print "Can not check deployment status without Deployment ID. Validate manually in Azure portal"
