from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

connector = AzureConnector(deployed.container)
network_client = connector.network_client()
subscription_id = connector.subscription_id

public_ip_parameters = {
    'location': deployed.location,
    'tags': deployed.publicIpAddressTags,
    'public_ip_allocation_method': deployed.publicIpAddressAllocationMethod,
    'idle_timeout_in_minutes': deployed.publicIpAddressIdleTimeoutInMinutes
}

public_ip_address_name = deployed.publicIpAddressName
resource_group_name = deployed.publicIpAddressResourceGroup

print "{0} Public IP {1} under Resource Group {2}".format(get_operation_name(previousDeployed), public_ip_address_name,
                                                          resource_group_name)

# asynchronous
op_result = network_client.public_ip_addresses.create_or_update(
    resource_group_name=resource_group_name,
    public_ip_address_name=public_ip_address_name,
    parameters=public_ip_parameters,
    raw=True
)

logger.info("Result: {0}".format(op_result))
