from msrestazure.azure_exceptions import CloudError
from xld.azure.connector import AzureConnector

connector = AzureConnector(previousDeployed.container)
network_client = connector.network_client()

public_ip_address_name = previousDeployed.publicIpAddressName
resource_group_name = previousDeployed.publicIpAddressResourceGroup

var_name = "public_ip_deleted_{0}".format(public_ip_address_name)
public_ip_deleted = context.getAttribute(var_name)

if not public_ip_deleted:
    print "Waiting for {0} to be completely destroyed".format(public_ip_address_name)
    try:
        logger.info("Trying to get info about Public IP ...")
        # synchronous
        public_ip_info = network_client.public_ip_addresses.get(
            resource_group_name,
            public_ip_address_name,
            None
        )
        result = "RETRY"
    except CloudError:
        # If the IP doesn't exist the sdk raises an exception
        # Azure says that the IP doesn't exist, but it still does so we wait 5 more seconds to ensure the IP is gone
        context.setAttribute(var_name, True)
        result = "RETRY"

logger.info("Public IP was successfully removed")
