from azure.mgmt.storage.models import StorageAccountCreateParameters, Sku, SkuName, Kind
from xld.azure import get_enum_by_value

from xld.azure.connector import AzureConnector

connector = AzureConnector(deployed.container)
storage_client = connector.storage_client()

storage_account_parameters = StorageAccountCreateParameters(
    sku=Sku(get_enum_by_value(deployed.storageAccountType, SkuName).name),
    kind=get_enum_by_value(deployed.storageAccountKind, Kind).name,
    location=deployed.location,
    tags=deployed.storageAccountTags
)

print "Creating Storage {0} under Resource Group {1}".format(
    deployed.storageAccountName, deployed.storageAccountResourceGroup)

# asynchronous
op_result = storage_client.storage_accounts.create(
    resource_group_name=deployed.storageAccountResourceGroup,
    account_name=deployed.storageAccountName,
    parameters=storage_account_parameters,
    raw=True
)

logger.info("Issued: {0}".format(op_result.response))
