from azure.mgmt.storage.models import StorageAccountUpdateParameters, Sku, SkuName
from xld.azure import check_persistent_parameters, get_enum_by_value

from xld.azure.connector import AzureConnector

connector = AzureConnector(deployed.container)
storage_client = connector.storage_client()

storage_account_parameters = StorageAccountUpdateParameters(
    sku=Sku(get_enum_by_value(deployed.storageAccountType, SkuName).name),
    tags=deployed.storageAccountTags
)

check_persistent_parameters(deployed, previousDeployed, ['storageAccountResourceGroup', 'storageAccountName'])

print "Modifying Storage {0} under Resource Group {1}".format(
    deployed.storageAccountName,
    deployed.storageAccountResourceGroup)

# synchronous
op_result = storage_client.storage_accounts.update(
    resource_group_name=deployed.storageAccountResourceGroup,
    account_name=deployed.storageAccountName,
    parameters=storage_account_parameters
)

logger.info("Result: {0}".format(op_result))
