from azure.mgmt.compute.models import ImageReference, NetworkInterfaceReference
from azure.mgmt.compute.models import OSDisk
from azure.mgmt.compute.models import SshPublicKey, SshConfiguration
from azure.mgmt.compute.models import StorageProfile, OSProfile, NetworkProfile, HardwareProfile
from azure.mgmt.compute.models import VirtualHardDisk, VirtualMachine
from azure.mgmt.compute.models import WindowsConfiguration, LinuxConfiguration

from xld.azure.connector import AzureConnector


def get_os_profile(admin_username, admin_password, computer_name, windows_configuration, linux_configuration,
                   custom_data):
    return OSProfile(
        admin_username=admin_username,
        admin_password=admin_password,
        computer_name=computer_name,
        custom_data=custom_data,
        windows_configuration=windows_configuration,
        linux_configuration=linux_configuration,
        secrets=None
    )


def get_vhd_uri(storage_name, vhd_name):
    return 'https://{0}.blob.core.windows.net/vhds/{1}.vhd'.format(
        storage_name,
        vhd_name,
    )


def get_storage_profile(disk_name, disk_vhd_uri, caching, create_option, disk_size_gb):
    return StorageProfile(
        image_reference=None,
        os_disk=OSDisk(
            name=disk_name,
            vhd=VirtualHardDisk(
                uri=disk_vhd_uri
            ),
            create_option=create_option,
            os_type=None,
            encryption_settings=None,
            image=None,
            caching=caching,
            disk_size_gb=disk_size_gb
        ),
        data_disks=None
    )


def get_network_profile(interfaces, resource_group_name):
    vm_network_interfaces = []
    for interface in interfaces:
        print "Looking up network interface {0}".format(interface)
        vm_network_interface = network_client.network_interfaces.get(
            resource_group_name,
            interface
        )
        print "Resolved to {0}".format(vm_network_interface.id)
        vm_network_interfaces.append(NetworkInterfaceReference(id=vm_network_interface.id))
    return NetworkProfile(network_interfaces=vm_network_interfaces)


def get_hardware_profile(the_vm_size):
    return HardwareProfile(
        vm_size=the_vm_size
    )


connector = AzureConnector(deployed.container)

compute_client = connector.compute_client()
network_client = connector.network_client()

if deployed.osStorageAccountName:
    vm_disk_vhd_uri = get_vhd_uri(deployed.osStorageAccountName, deployed.osDiskName)
else:
    vm_disk_vhd_uri = deployed.osVhd

vm_storage_profile = get_storage_profile(
    disk_name=deployed.osDiskName,
    disk_vhd_uri=vm_disk_vhd_uri,
    caching=deployed.caching,
    create_option=deployed.createOption,
    disk_size_gb=deployed.diskSizeGb)

vm_storage_profile.image_reference = ImageReference(
    publisher=deployed.publisher,
    offer=deployed.offer,
    sku=deployed.sku,
    version=deployed.version
)

vm_linux_configuration = None
if deployed.enableLinuxConfiguration:
    ssh_config = None
    if deployed.publicKeys:
        ssh_config = SshConfiguration()
        ssh_config.public_keys = [SshPublicKey(path=key, key_data=value)
                                  for key, value in deployed.publicKeys.iteritems()]
    print "configuring keys {0} via linux configuration , password authentication is {1}".format(
        ssh_config.public_keys,
        deployed.disablePasswordAuthentication)
    vm_linux_configuration = LinuxConfiguration(
        disable_password_authentication=deployed.disablePasswordAuthentication,
        ssh=ssh_config)

vm_windows_configuration = None
if deployed.enableWindowsConfiguration:
    vm_windows_configuration = WindowsConfiguration(
        provision_vm_agent=deployed.provisionVmAgent,
        enable_automatic_updates=deployed.enableAutomaticUpdates,
        time_zone=deployed.timeZone,
        additional_unattend_content=None,
        win_rm=None
    )

vm_params_create = VirtualMachine(
    location=deployed.location,
    tags=deployed.virtualMachineTags,
    plan=None,
    os_profile=get_os_profile(
        admin_username=deployed.adminUserName,
        admin_password=deployed.adminPassword,
        computer_name=deployed.computerName,
        linux_configuration=vm_linux_configuration,
        windows_configuration=vm_windows_configuration,
        custom_data=deployed.customData),
    hardware_profile=get_hardware_profile(deployed.vmSize),
    storage_profile=vm_storage_profile,
    network_profile=get_network_profile(deployed.networkInterfaces, deployed.resourceGroupName),
    diagnostics_profile=None,
    availability_set=None,
    license_type=None
)

print "Creating VM {0} on {1} ....".format(deployed.virtualMachineName, deployed.resourceGroupName)

# Create VM
op_result = compute_client.virtual_machines.create_or_update(
    resource_group_name=deployed.resourceGroupName,
    vm_name=deployed.virtualMachineName,
    parameters=vm_params_create,
    raw=True
)
logger.info("Result: {0}".format(op_result))
