from xld.azure import wait_for_success_provisioning

from xld.azure.connector import AzureConnector

connector = AzureConnector(previousDeployed.container)
compute_client = connector.compute_client()

# synchronous
op_result = compute_client.virtual_machines.get(
    resource_group_name=previousDeployed.resourceGroupName,
    vm_name=previousDeployed.virtualMachineName,
    expand='instanceview'
)

if (op_result.instance_view and
   op_result.instance_view.statuses and
   op_result.instance_view.statuses[0].code.startswith('ProvisioningState/failed')):
    print "VM is already in faulty state, nothing to stop ({0})".format(op_result.instance_view.statuses[0].code)
else:
    result = wait_for_success_provisioning(op_result, previousDeployed.virtualMachineName)
    if (result == "SUCCESS" and
       op_result.instance_view.statuses and
       op_result.instance_view.statuses[1].code != 'PowerState/stopped'):
        print "Waiting for {0} to be stopped ({1})".format(
            previousDeployed.virtualMachineName,
            op_result.provisioning_state)
        result = "RETRY"

logger.info("Result: {0}".format(op_result))
