import os.path
import string
from xld.azure.blob_container.blob_file_helper import BlobFileHelper
from xld.azure.connector import AzureConnector


def process_files(root_dir, container_name):
    for subdir, dirs, files in os.walk(root_dir):
        for thefile in files:
            target_file_name = os.path.join(subdir.replace(root_dir, ''), thefile).strip("/")
            print "removing {0} from {1}".format(target_file_name, container_name)
            blob_file_helper.delete_file_from_container(container_name, target_file_name)


bc = previousDeployed.container  # blob container
rg = bc.container
cloud = rg.container
connector = AzureConnector(cloud)  # accomplish certifi patch

blob_file_helper = BlobFileHelper(previousDeployed)
container_name = previousDeployed.container.containerName

process_files(previousDeployed.file.path, container_name)
