from azure.mgmt.containerinstance.models import Container, ResourceRequirements, ResourceLimits, \
    ResourceRequests, EnvironmentVariable, ContainerPort, ContainerGroup, IpAddress, Port
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

container_client = connector.container_client()

container_group_ports = [Port(port=someport)
                         for someport in deployed.ports
                         ]

container_group_containers = []

for container in deployed.containers:

    container_env_vars = []

    if container.environmentVariables:
        container_env_vars = [EnvironmentVariable(name=key, value=value)
                              for key, value in container.environmentVariables.iteritems()
                              ]

    container_ports = [ContainerPort(port=someport)
                       for someport in container.ports
                       ]

    container_resource_requirements = ResourceRequirements(
        requests=ResourceRequests(
            cpu=container.resourceRequestsCpu,
            memory_in_gb=container.resourceRequestsMemoryGb
        ),
        limits=ResourceLimits(
            memory_in_gb=container.resourceLimitsCpu,
            cpu=container.resourceLimitsMemoryGb
        )
    )

    container_instance = Container(
        name=container.containerName,
        image=container.containerImage,
        resources=container_resource_requirements,
        environment_variables=container_env_vars,
        ports=container_ports
    )

    container_group_containers.append(container_instance)


container_group_params = ContainerGroup(
    location=deployed.location,
    os_type=deployed.osType,
    ip_address=IpAddress(
        ports=container_group_ports
    ),
    containers=container_group_containers
)

print "{0} Container Group {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    deployed.containerGroupName,
    rg.resourceGroupName
)

# synchronous
op_result = container_client.container_groups.create_or_update(
    resource_group_name=rg.resourceGroupName,
    container_group_name=deployed.containerGroupName,
    container_group=container_group_params
)

deployed.ipAddress = op_result.ip_address.ip

print "Group is available at {0}".format(deployed.ipAddress)
print "with containers: {0}".format(["{0} ({1})".format(c.name, c.image) for c in container_group_containers])

logger.info("Result: {0}".format(op_result))
