from xld.azure import check_persistent_parameters, get_operation_name

from xld.azure.connector import AzureConnector

cloud = deployed.container
connector = AzureConnector(cloud)
resource_client = connector.resource_client()

# https://docs.microsoft.com/en-us/dotnet/api/microsoft.azure.management.resourcemanager.models.resourcegroup
# http://azure-sdk-for-python.readthedocs.io/en/latest/ref/azure.mgmt.resource.resources.html

# Required
# name Name of the resource group.

# Optional
# location Azure location for the resource group. Required when creating a new
#  resource group. Cannot be changed once resource group is created.

# Unknown
# id String The ID of the resource group
# properties ResourceGroupProperties The location of the resource group.
# It cannot be changed after the resource group has been created. Has to be one
# of the supported Azure Locations, such as
# West US, East US, West Europe, East Asia, etc.
# managedBy String Id of the resource that manages this resource group.

check_persistent_parameters(deployed, previousDeployed, ['resourceGroupName'])

resource_group_name = deployed.resourceGroupName

print "{0} Resource Group {1} under SubscriptionId {2}".format(
    get_operation_name(previousDeployed),
    resource_group_name,
    connector.subscription_id)

# synchronous
op_result = resource_client.resource_groups.create_or_update(
    resource_group_name=resource_group_name,
    parameters={
        'location': deployed.location,
        'tags': deployed.resourceGroupTags
    }
)
logger.info("Result: {0}".format(op_result))
