from xld.azure import wait_for_success_provisioning

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
compute_client = connector.compute_client()

# synchronous
op_result = compute_client.virtual_machines.get(
    resource_group_name=rg.resourceGroupName,
    vm_name=deployed.virtualMachineName,
    expand='instanceview'
)

result = wait_for_success_provisioning(op_result, deployed.virtualMachineName)

if (result == "SUCCESS" and op_result.instance_view.statuses and
        op_result.instance_view.statuses[1].code != 'PowerState/running'):
    print "Waiting for {0} to be started ({1})".format(deployed.virtualMachineName, op_result.provisioning_state)
    result = "RETRY"
else:
    network_interface_name = op_result.network_profile.network_interfaces[0].id.split('/')[-1]
    network_client = connector.network_client()
    network_interface = network_client.network_interfaces.get(
        resource_group_name=rg.resourceGroupName,
        network_interface_name=network_interface_name)
    print "Private IP {0}".format(network_interface.ip_configurations[0].private_ip_address)
    deployed.privateIp = network_interface.ip_configurations[0].private_ip_address
    if network_interface.ip_configurations[0].public_ip_address:
        public_ip_name = network_interface.ip_configurations[0].public_ip_address.id.split('/')[-1]
        network_client_2 = connector.network_client()
        public_ip = network_client_2.public_ip_addresses.get(
            resource_group_name=rg.resourceGroupName,
            public_ip_address_name=public_ip_name
        )
        print "Public IP is {0}".format(public_ip.ip_address)
        deployed.publicIp = public_ip.ip_address
        print "PublicIPName is {0}".format(public_ip.name)
        deployed.publicIpName = public_ip.name

logger.info("Result: {0}".format(op_result))
