import json
from com.xebialabs.deployit.plugin.azure import AzureHelper

azure_helper = AzureHelper(deployed.container)

deploymentName = deployed.deploymentName
resourceGroupName = deployed.resourceGroupName

if not deploymentName or not deploymentName.strip():
    raise Exception("Template '%s' must have its 'Deployment Name' set" % deployed.name)

plugin = authenticate(deployed)

if not plugin.resourceGroupExists:
    raise Exception("Resource Group '%s' does not exist." % resourceGroupName)

plugin.loadTemplate(deployed.file.path)

parameters = {}
input_variables = deployed.inputVariables
for k in input_variables:
    parameters[k] = {'value': input_variables[k]}

plugin.deploy(resourceGroupName, deploymentName, deployed.file.path, json.dumps(parameters), deployed.deploymentMode)
