import time
from com.xebialabs.deployit.plugin.azure import AzureHelper

azure_helper = AzureHelper(previousDeployed.container)

deploymentName = previousDeployed.deploymentName
resourceGroupName = previousDeployed.resourceGroupName

if not deploymentName or not deploymentName.strip():
    raise Exception("Template '%s' must have its 'Deployment Name' set" % previousDeployed.name)

interval_count = 0
sleep_interval = 5

if azure_helper.resourceGroupExists(resourceGroupName):
    while True:
        interval_count += 1
        if interval_count > previousDeployed.maxRetries:
            raise Exception("Resource Group '%s' timed out waiting for 'Deleted'" % resourceGroupName)

        if azure_helper.resourceGroupExists(resourceGroupName):
            state = azure_helper.getResourceGroup(resourceGroupName).provisioningState()
            if state and state.lower() == 'failed':
                raise Exception("Deletion of Resource Group '%s' failed." % resourceGroupName)
            else:
                print('Current state is %s. Waiting 5 seconds.' % state)
            time.sleep(sleep_interval)
        else:
            print("Resource Group '%s' is deleted" % resourceGroupName)
            break
else:
    print("Resource Group '%s' does not exist. Ignoring." % resourceGroupName)
