from azure.mgmt.web.models import Site, SiteConfig, NameValuePair
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = deployed.appName or deployed.name

print "{0} Web App {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    web_app_name,
    resource_group_name)

plan_info = web_client.app_service_plans.get(
    resource_group_name=resource_group_name,
    name=deployed.servicePlanName
)

if not plan_info:
    raise Exception("Service plan {0} not found".format(deployed.servicePlanName))

server_farm_id="/subscriptions/" + connector.subscription_id + "/resourceGroups/" + resource_group_name + "/providers/Microsoft.Web/serverfarms/" + deployed.servicePlanName

web_app_settings = []
if deployed.appSettings.keys():
    for key,value in deployed.appSettings.items():
            web_app_settings.append(NameValuePair(name=key, value=value))

web_app_conn_strings = []
if deployed.sqlDatabaseConnectionStrings.keys() or deployed.sqlServerConnectionStrings.keys() or deployed.customConnectionStrings.keys():
    for key,value in deployed.sqlDatabaseConnectionStrings.items():
            web_app_conn_strings.append(ConnStringInfo(name=key, connection_string=value, type='SQLAzure'))
    for key,value in deployed.sqlServerConnectionStrings.items():
            web_app_conn_strings.append(ConnStringInfo(name=key, connection_string=value, type='SQLServer'))
    for key,value in deployed.customConnectionStrings.items():
            web_app_conn_strings.append(ConnStringInfo(name=key, connection_string=value, type='Custom'))

# asynchronous
op_result = web_client.web_apps.create_or_update(
    resource_group_name=resource_group_name,
    name=web_app_name,
    site_envelope=Site(
        location=deployed.location,
        server_farm_id=server_farm_id,
        site_config=SiteConfig(
            app_settings=web_app_settings,
            connection_strings=web_app_conn_strings,
            always_on=True
        )
    ),
    raw=True
)

logger.info("Result: {0}".format(op_result))
