from azure.mgmt.web.models import AppServicePlan, SkuDescription
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

service_plan_name = deployed.servicePlanName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name


print "{0} App Service Plan {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    service_plan_name,
    resource_group_name)

op_result = web_client.app_service_plans.create_or_update(
    resource_group_name=resource_group_name,
    name=service_plan_name,
    app_service_plan=AppServicePlan(
        location=deployed.location,
        sku=SkuDescription(
                name=deployed.skuName,
                tier=deployed.skuTier,
                size=deployed.skuSize,
                family=deployed.skuFamily,
                capacity=deployed.skuCapacity
        )
    ),
    raw=True
)

logger.info("Result: {0}".format(op_result))
