/* eslint-disable max-lines,max-len*/
export default {
    abortButton: 'Abort',
    aboutBoxClasspathTabTitle: 'Server Classpath',
    aboutBoxInstalledPluginsTabTitle: 'Installed Plugins',
    aboutBoxLicenseTabTitle: 'License',
    aboutBoxVersionTabTitle: 'Version',
    aboutOption: 'About',
    aboutToLeaveWithoutSavingMessage: 'You are about to leave without saving. Are you sure?',
    actionsTitle: 'Actions',
    addNewRoleLabel: 'New role',
    adminPermissionTitle: 'admin',
    allButton: 'All',
    allPlaceholder: 'All',
    allTasksButton: 'All tasks',
    applicationLabel: 'Application',
    applicationTitle: 'Application',
    appSummaryCiIdLabel: 'ID: ',
    appSummaryCiTypeLabel: 'Type: ',
    appSummaryEditPropertiesButton: 'Edit properties',
    appSummaryEnvironmentsTitle: 'Environments where application is deployed',
    appSummaryLatestDeploymentsTitle: 'Latest deployments',
    appSummaryPipelineTitle: 'Pipeline<% if(name) {%>: <%= name %> <%} %>',
    blockLogMessage: 'There is no log output for task blocks. Please select a step to view the log output.',
    cancelButton: 'Cancel',
    cancelCurrentTaskMessage: 'Are you sure you want to cancel the current task?',
    canceledDeploymentTooltip: 'Cancelled deployment',
    cancelTaskButton: 'Cancel task',
    cannotPromoteMessage: 'Checklist incomplete. Cannot promote to <%= environment %>.',
    cantArchiveMessage: 'The task cannot be archived through the CI Explorer. Please use the Deployment Workspace to archive the task.',
    cantArchiveTitle: "Can't archive",
    cantRenameBodyMessage: 'Cannot rename CI because the new name is empty or contains characters that are not allowed.',
    cantRenameTitle: "Can't rename",
    cantUndeployMessage: 'The package cannot be undeployed through the CI Explorer. Please use the Deployment Workspace to undeploy the package.',
    cantUndeployTitle: "Can't undeploy",
    checklistTitle: 'Checklist for <%= version %> to <%= environment %> <%= pristine ? "" : "*" %>',
    chooseFileLabel: 'Choose file',
    ciComparisonTitle: 'Compare <%= ciId %>',
    ciHistoryTitle: 'History of <%= ciId %>',
    ciIdDescription: 'Full item folder structure.',
    ciNameDescription: 'The name of the configuration item.',
    ciTypeDescription: 'The type of a configuration item.',
    clearButton: 'Clear',
    clearButtonTitle: 'Clear all the permissions for this role.',
    closeAllTabsAction: 'Close all tabs',
    closeButton: 'Close',
    closeOtherTabsAction: 'Close other tabs',
    closePreviewButton: 'Close preview',
    compareCiHelpText: 'To compare, drag an item from the Library on the left (up to 5 items).',
    compareCiLimitReachedText: 'You can compare up to five configuration items.',
    compareCiLimitWarningText: 'You can compare up to five configuration items. To compare a different item, first remove one.',
    compareMenuProperty: 'Compare',
    compareWithOtherCiAction: 'With other CI',
    compareWithPreviousAction: 'With previous version',
    configureTitle: 'Configure',
    confirmDeleteCI: 'Are you sure you want to delete ',
    confirmDeleteRole: 'You are about to delete role <%= name %>. Are you sure?',
    confirmLeaveCiSaveTitle: 'Leave without saving <%= ciName %>?',
    confirmMoveCi: 'Are you sure you want to move <%= sourceCiName %> to <%= targetCiId %>?',
    confirmMoveTitle: 'Confirm move',
    confirmRollback: 'Are you sure you want to roll back the current task?',
    continueButton: 'Continue',
    controlFlowTitle: 'Control task [<%= metadata.taskLabel %>] for <%= metadata.controlTaskTargetCI %>',
    controlTaskExecutePermissionTitle: 'control task execute',
    controlTasksReportControlTaskNameColumnName: 'Control task name',
    controlTasksReportDescriptionColumnName: 'Description',
    controlTasksReportEndDateColumnName: 'End date',
    controlTasksReportStartDateColumnName: 'Start date',
    controlTasksReportStateColumnName: 'State',
    controlTasksReportTabTitle: 'Control Tasks',
    controlTasksReportTargetCIColumnName: 'Target CI',
    controlTasksReportUserColumnName: 'User',
    controlTasksTitle: 'Control tasks',
    copyrightNotice: 'Copyright © XebiaLabs Group. All rights reserved.',
    currentlyDeployed: '<%= currentlyDeployed %> (currently deployed)',
    currentlyDeployedLabel: 'Currently deployed:',
    currentlyDeployedVersion: '<%= envName %> (currently deployed: <%= currentlyDeployed %>)',
    currentMonthHeader: 'Current month (<%= periodLabel %>)',
    daysSuffix: 'day',
    deleteAction: 'Delete',
    deleteCiMessage: 'It will be fully removed from XL Deploy.',
    deleteCiTitle: 'Delete <%= ciName%>?',
    deleteRoleLabel: 'Delete role <%= name %> ?',
    deployAction: 'Deploy',
    deployButton: 'Deploy',
    deployConfigurationTitle: 'Deploy <%= appVersionName %> to <%= environment %>',
    deployFlowTitle: 'Deploy <%= metadata.application %> <%= metadata.version %> to <%= metadata.environment %>',
    deployInitialPermissionTitle: 'deploy initial',
    deployLabel: 'Deploy',
    deployLatestAction: 'Deploy latest',
    deployLatestPackageNotFoundToastrMessage: 'Latest package cannot be found',
    deployedAppNameTitle: '<%= id%> (<%= version %>)',
    deployedLabel: 'Deployed:',
    deployedPanelPopoverValidationHeader: '<%= count %> <%= type %><% if(count > 1) {%>s<%} %>',
    deployedValidationNameNotUnique: 'The deployed must have a unique name within the container',
    deployedValidationNotificationMessage: '<%= message %> for <%= property %>',
    deployment: 'deployment',
    deploymentChecklistLabel: 'Deployment checklist',
    deploymentPanelHeader: '<%= deploymentType %> DEPLOYMENT',
    deploymentPipelineAction: 'Deployment pipeline',
    deploymentPipelineTitle: 'Deployment pipeline',
    deploymentPropertiesButton: 'Deployment Properties',
    deploymentPropertiesTitle: 'Deployment Properties',
    deploymentsReportApplicationsRadioLabel: 'Application(s)',
    deploymentsReportCompletionDateColumnName: 'End Date',
    deploymentsReportDeploymentTypeColumnName: 'Deployment Type',
    deploymentsReportEnvironmentColumnName: 'Environment',
    deploymentsReportEnvironmentsRadioLabel: 'Environment(s)',
    deploymentsReportNoneRadioLabel: 'None',
    deploymentsReportPackageColumnName: 'Package(s)',
    deploymentsReportStartDateColumnName: 'Start Date',
    deploymentsReportStatusColumnName: 'State',
    deploymentsReportTabTitle: 'Deployments',
    deploymentsReportUserColumnName: 'User',
    deploymentStatusCancelled: 'Cancelled',
    deploymentStatusDone: 'Done',
    deploymentTasksTitle: 'Deployment tasks',
    deploymentTypeInitial: 'Initial',
    deploymentTypeRollback: 'Rollback',
    deploymentTypeUndeploy: 'Undeploy',
    deploymentTypeUndeployment: 'Undeployment',
    deploymentTypeUpdate: 'Update',
    deploymentTypeUpgrade: 'Upgrade',
    deploymentWorkspaceHelpText: 'To start a deployment, drag a package and an environment here. To perform an update, you can drag a deployed application and a new deployment package.',
    deploymentWorkspaceTitle: 'Deployment Workspace',
    deployUndeployPermissionTitle: 'deploy undeploy',
    deployUpgradePermissionTitle: 'deploy upgrade',
    descriptionLabel: 'Description',
    disableButton: 'Disable',
    discardChangesAndSaveCisButton: 'Discard changes and save CIs',
    discoverAction: 'Discover',
    discoverButton: 'Discover',
    discoveredCisNoPermissionsMessage: 'You do not have permission to save the discovered CIs',
    discoveredItemsTitle: 'DISCOVERED ITEMS',
    discoverFlowTitle: '<%= description %>',
    discoverTitle: 'Discover',
    discoveryConfigurationFlowTitle: 'Discover <%= ciType %>',
    discoveryPermissionTitle: 'discovery',
    doNotDeleteButton: 'Do not delete',
    dragDropEnvironment: 'Drag and drop environment here',
    dragDropPackage: 'Drag and drop package here',
    duplicateAction: 'Duplicate',
    durationInHours: 'hours',
    durationInMinutes: 'minutes',
    durationInSeconds: 'seconds',
    durationTemplate: '<%= days %>d <%= hours %>h <%= minutes %>m',
    editAction: 'Edit',
    editDeployedItem: 'Edit deployed item',
    editionLabel: 'Edition',
    editPermissionsAction: 'Edit permissions',
    editPropertiesAction: 'Edit properties',
    editRoleLabel: 'Edit <%= name %> role',
    emptyTargetedLabel: 'targeted (No deployables could be mapped)',
    enableButton: 'Enable',
    endDateLabel: 'End date',
    environmentLabel: 'Environment',
    environmentsLabel: 'Environments',
    environmentsUnavailableMessage: 'You cannot deploy because there are no environments available',
    environmentTitle: 'Environment',
    errorTitle: 'Error',
    errorTitleOfRenamingCi: 'Error renaming CI',
    executeButton: 'Execute',
    executionPlanTitle: 'EXECUTION PLAN',
    executionTitle: 'Execution',
    explorerTab: 'Explorer',
    exportAction: 'Export',
    exportReport: 'Export report',
    filterButton: 'Filter',
    finishButton: 'Finish',
    finishLabel: 'Finish',
    formattedErrorMessage: '<%= message %> for <%= property %> in <%= ciName %>',
    fromLabel: 'from',
    generateDeployfileAction: 'Generate Example Deployfile',
    generateDslPermissionTitle: 'generate dsl',
    generatingPreviewText: 'Generating preview...',
    genericToastrErrorTitle: 'Error',
    globalPermissionsTabTitle: 'Global Permissions',
    headerDiscovery: 'DISCOVERY',
    headerInitialDeployment: 'INITIAL DEPLOYMENT',
    headerInitialOrUpdateDeployment: 'DEPLOYMENT',
    headerRollbackDeployment: 'ROLLBACK',
    headerUndeployment: 'UNDEPLOYMENT',
    headerUpdateDeployment: 'UPDATE DEPLOYMENT',
    hideButton: 'Hide',
    hideFiltersButton: 'Hide filters',
    hostsLabel: 'Hosts',
    hoursSuffix: 'hr',
    idLabel: 'ID',
    importButton: 'Import',
    importFromComputerAction: 'From computer',
    importFromUrlAction: 'From URL',
    importFromXlDeployServerAction: 'From XL Deploy server',
    importInitialPermissionTitle: 'import initial',
    importMenuProperty: 'Import',
    importPackageFromComputerDescription: 'Package to import.',
    importPackageFromComputerLabel: 'Package',
    importPackageFromComputerTitle: 'Import from computer',
    importPackageFromUrlLabel: 'URL',
    importPackageFromUrlTitle: 'Import from URL',
    importPackageFromXlDeployServerDescription: 'Package to import.',
    importPackageFromXlDeployServerLabel: 'Package',
    importPackageFromXlDeployServerTitle: 'Import from XL Deploy server',
    importPackagePasswordDescription: 'Password to use when importing the package.',
    importPackagePasswordLabel: 'Password',
    importPackageUrlDescription: 'Location of the package (for example, a CI server or artifact repository).',
    importPackageUserDescription: 'User name to use when importing the package.',
    importPackageUserLabel: 'User',
    importRemovePermissionTitle: 'import remove',
    importUpgradePermissionTitle: 'import upgrade',
    incompleteDeploymentWorkspaceTitle: '... to <%= basename %>',
    incompleteInitialDeploymentTitle: 'Deploy <%= appVersionName %> to ...',
    incompleteUpdateDeploymentTitle: 'Update <%= applicationName %> <%= versionName %> to ...',
    incorrectCredentialsMessage: 'The username and/or password you have entered is incorrect.',
    infoTitle: 'Information',
    inProgress: 'In progress',
    invalidCharactersLabel: 'Please enter only valid characters for the Name (no `/`, `\\`, `:`, `[`, `]`, `|`, `,` or `*`)',
    invalidUrlLabel: 'Please enter a valid url',
    keepMeLoggedInLabel: 'Keep me logged in',
    keyLabel: 'Key',
    last30daysHeader: 'Last 30 days (<%= periodLabel %>)',
    last6monthsHeader: 'Last 6 months (<%= periodLabel %>)',
    lastDeploymentByLabel: '<%= at %> by <%= by %>',
    lastDeploymentLabel: 'Last deployment:',
    lastDeploymentTitle: 'Last deployment (<%= currentlyDeployed %>)',
    lastUpdatedTimestamp: 'Last updated: <%= timestamp %>',
    leaveAction: 'Leave',
    legacyInterfaceOption: 'Go to legacy interface',
    libraryLabel: 'Library',
    licensedApplicationsLabel: 'Licensed # of Applications',
    licensedContactLabel: 'License contact',
    licenseDescription: 'The limits of your XL Deploy license apply to all instances of XL Deploy that use the license. For compliance purposes, please ensure that the total number of configuration items used in all instances does not exceed the limits of the license.',
    licensedHostsLabel: 'Licensed # of Hosts',
    licensedPluginsLabel: 'Licensed plugins',
    licensedSatellitesLabel: 'Licensed # of Satellites',
    licensedToLabel: 'Licensed to',
    licenseExpiredMessage: 'This XL Deploy server will not function due to a license problem. Please contact your administrator or enter a valid license <a href="productregistration" target="_blank">here</a>.',
    licenseExpiryDateLabel: 'License expires after',
    licenseUsage: '<%= licensed %> (in use: <%= inUse %>)',
    loggedInAsLabel: 'Logged in as',
    loginButton: 'Log in',
    loginPermissionTitle: 'login',
    loginTitle: 'Log in',
    logoutOption: 'Log out',
    lostChangesNotification: 'Are you sure you want to leave? Your changes will be lost.',
    maintenanceModeOption: 'Maintenance mode',
    maintenanceModePanelMessage: 'XL Deploy is currently under maintenance. Some actions may not be available. Please try again later.',
    maintenanceModeText: 'Maintenance mode prevents user from starting new deployments, so you can safely restart XL Deploy server. When you enable maintenance mode, deployments that have already started will be allowed to finish. Use Task Monitor to view deployments that are in progress.',
    maintenanceModeTitle: 'Maintenance mode',
    mapAllDeployables: 'Map all deployables',
    mapDeployables: 'Map deployables',
    millisecondsSuffix: 'ms',
    minutesSuffix: 'min',
    modifyPlanButton: 'Modify plan',
    moveAction: 'Move',
    myTasksButton: 'My tasks',
    nameAlreadyInUse: 'Name is already in use',
    nameLabel: 'Name',
    newAction: 'New',
    newRoleAction: 'Add role',
    newTabTitle: 'New Tab',
    noButton: 'No',
    noDataAvailableLabel: 'No data available for the current period',
    noDataLabel: 'No data',
    noDeploymentsMessage: 'No deployments.',
    noEnvironmentsAssignedToPipelineMessage: 'No environments assigned to the deployment pipeline.',
    noLatestDeploymentsMessage: 'No deployments found in the last 6 months.',
    noLeadingOrTrailingSpaces: (ciName) => `The CI name [${ciName}] must not contain leading or trailing spaces`,
    noLoginPermissions: 'You do not have permission to log in. Please contact your system administrator.',
    noPermissionToDeploymentPipelineEnvironmentsMessage: 'You do not have permission to view all environments in the deployment pipeline for this application.',
    noPermissionToDeploymentPipelineMessage: 'You do not have permission to view the deployment pipeline for this application.',
    noPreviousRevisionsMessage: 'There are no previous versions',
    noReportsViewPermissionMessage: 'You do not have the `report#view` global permission to see the latest deployments.',
    noSearchResultsText: 'No results found',
    noteLabel: 'Note:',
    nothingToMapLabel: 'There are no containers in the environment',
    noVersionsMessage: '<%= appName %> does not have any versions.',
    onLabel: 'on',
    onlineDocumentation: 'Online documentation',
    onlyMyButton: 'Only my',
    openCIPermissionsTitle: '<%= basename %> permissions',
    orderLabel: 'Order',
    outOfLabel: '<%= value %> out of <%= total %>',
    packageLabel: 'Package',
    packagesLabel: 'Packages',
    passwordLabel: 'Password',
    passwordPlaceholder: 'Password',
    pastTimeErrorText: 'Scheduled date and time must be in the future',
    pauseAfterButton: 'Pause after',
    pauseBeforeButton: 'Pause before',
    pendingLogMessage: 'There is no log output available for pending steps.',
    pluginColumnTitle: 'Plugin',
    previewButton: 'Preview',
    previewPermissionNotGivenLabel: 'You do not have permission to preview the step.',
    previewTitle: 'Preview',
    previewUnavailableLabel: 'Preview not available',
    principalsDescription: 'Type in names for principals.',
    principalsTitle: 'Principals',
    productNameLabel: 'Product',
    promoteToNextButton: 'Promote to next environment',
    rateTitle: 'Rate',
    readPermissionTitle: 'read',
    referenceLabel: '(Reference)',
    refreshButton: 'Refresh',
    remainingDays: 'days remaining: <%= remainingDays %>',
    removeDeployables: 'Remove deployables',
    removeDeployed: 'Remove deployed',
    removeLabel: 'Remove <%= comparedCi %> from comparison',
    renameAction: 'Rename',
    renamingCiErrorTitle: 'Error renaming CI',
    renewLicenceOption: 'Renew license',
    repoEditPermissionTitle: 'repo edit',
    reportEmptyMessage: 'No report data available for the selected filter',
    reportErrorMessage: 'Error while fetching report',
    reportPaginationTotals: 'Total: <%= total %>',
    reportsDashboardAverageDeploymentAvgDuration: 'Avg.duration: <%= avgDuration %>',
    reportsDashboardAverageDeploymentDurationOverTimeTitle: 'Average deployment duration over time',
    reportsDashboardAverageDeploymentSuccessful: 'Successful: <%= percentageSuccessfulDeployments %>% (<%= noOfSuccessfulDeployments %> deployments)',
    reportsDashboardAverageDeploymentTotalDeployments: 'Deployments: <%= totalDeployments %>',
    reportsDashboardDeploymentStatusOverviewTitle: 'Deployment status overview',
    reportsDashboardTabTitle: 'Dashboard',
    reportsDashboardTopLongestDeploymentsTooltipApplication: 'Application: <%= application %>',
    reportsDashboardTopLongestDeploymentsTooltipDuration: 'Deployment duration: <%= duration %> minutes',
    reportsDashboardTopLongestDeploymentsTooltipEnvironment: 'Environment: <%= environment %>',
    reportsDeploymentOverviewAborted: 'Aborted',
    reportsDeploymentOverviewRetried: 'Retried',
    reportsDeploymentOverviewRollback: 'Rollback',
    reportsDeploymentOverviewSuccessful: 'Successful',
    reportsDeploymentsOverTimeAborted: 'Aborted',
    reportsDeploymentsOverTimeNumberOfDeployments: '# of deployments',
    reportsDeploymentsOverTimeRetried: 'Retried',
    reportsDeploymentsOverTimeRollback: 'Rollback',
    reportsDeploymentsOverTimeSuccessful: 'Successful',
    reportsDeploymentsOverTimeTitle: 'Number of deployments over time',
    reportsTab: 'Reports',
    reportTabDeployments: 'Deployments',
    reportViewPermissionTitle: 'report view',
    resetButton: 'Reset',
    retriedTotalTitle: 'Retried/Total #',
    roleDescription: 'Provide a unique name for the role.',
    roleExitsLabel: 'Role name <%= name %> already exists',
    rolesColumnTitle: 'Roles',
    rolesTabTitle: 'Roles',
    roleTitle: 'Role',
    rollbackButton: 'Rollback',
    rollbackFlowTitle: 'Roll back <%= metadata.application %> <%= metadata.version %> on <%= metadata.environment %>',
    rollbacklabel: 'Roll back',
    ruleLabel: 'Rule',
    satellitesLabel: 'Satellites',
    saveAndPromoteButton: 'Save and promote',
    saveButton: 'Save',
    saveChangesAndSaveCisButton: 'Save changes and save CIs',
    saveChangesButton: 'Save changes',
    saveCisWithChangesTitle: 'Save CIs with changes?',
    saveDiscoveredCisButton: 'Save discovered CIs',
    saveDiscoveredCisWithChangesMessage: 'You have unsaved changes. Do you want to save them before saving the discovered CIs?',
    saveErrorMessage: 'Your change could not be saved.',
    saveSuccessMessage: 'Your change was saved.',
    scheduleButton: 'Schedule',
    scheduleConfirmLabel: 'When would you like to schedule this task?',
    scheduleDateLabel: 'Select the date',
    scheduleFailedMessage: 'Your <%= type %> for <%= date %> at <%= time %> failed.',
    scheduleFailedTitle: 'Schedule failed',
    scheduleLabel: 'Schedule',
    scheduleSucceededMessage: 'Your <%= type %> is scheduled for <%= date %> at <%= time %>.',
    scheduleSucceededTitle: 'Schedule succeeded',
    scheduleTimeLabel: 'Select the time',
    scheduleTitle: 'Schedule',
    searchPlaceholder: 'Search',
    secondsSuffix: 'sec',
    securityEditPermissionTitle: 'security edit',
    selectDiscoveredItemLabel: 'Click a discovered item to view or edit properties',
    selectEnvironmentTitle: 'Select Environment',
    selectVersionPlaceholder: 'Select Package',
    selectVersionTitle: 'Select Package',
    serverVersion: 'Server version: <%= serverVersion %>',
    sessionExpiredMessage: 'Session has expired',
    showButton: 'Show',
    showFiltersButton: 'Show filters',
    showFullReportLabel: 'Show full report',
    skipAllSelectedButton: 'Skip selected steps',
    skipButton: 'Skip',
    sourcePathLabel: 'Source path',
    stageConfigure: 'Configure',
    stageExecution: 'Execution',
    stageRollback: 'Rollback',
    stageUndeploy: 'Undeploy',
    startDateLabel: 'Start date',
    startDeploymentButton: 'Start a deployment',
    startLabel: 'Start',
    stateLabel: 'State',
    stayOnPageButton: 'Stay on the page',
    stepLogMessage: 'There is no log output available for a <%= state %> step.',
    stepNumberLabel: 'Step number',
    stepScriptTitle: 'Step preview',
    stopButton: 'Stop',
    submitSupportRequest: 'Submit a support request',
    successfulDeploymentTooltip: 'Successful deployment',
    successfulImport: 'Imported successfully',
    successTitle: 'Success',
    successTotalTitle: 'Success/Total #',
    suggestFeature: 'Suggest a feature',
    supportPolicyLabel: 'Support policy',
    targetedLabel: 'targeted',
    targetLabel: 'Target',
    taskAssignPermissionTitle: 'task assign',
    taskAssignTitle: 'Assign task',
    taskAssignToLabel: 'Assign to',
    taskAssignToMe: 'Assign to me',
    taskAssignToUser: 'Assign to user...',
    taskAssignToUserDescription: 'Select the user you would like to assign this task to.',
    taskIdLabel: 'Task ID',
    taskIdTitle: 'Task ID - <%= taskId %>',
    taskMonitor: 'Task Monitor',
    taskMonitorErrorMessage: 'Error while fetching tasks',
    taskMoveStepPermissionTitle: 'task move step',
    taskNameLabel: 'Task Name',
    taskOpenPermissionNotGivenLabel: 'You do not have permission to view this task',
    taskPreviewStepPermissionTitle: 'task preview step',
    tasksEmptyMessage: 'No tasks available for the selected filter',
    tasksLabel: 'Tasks',
    taskSkipStepPermissionTitle: 'task skip step',
    taskSuccessfullyAssignedToUser: 'The task was successfully assigned to <%= newUser %>',
    taskTakeoverPermissionTitle: 'task takeover',
    taskWillBeAbortedNotification: 'Closing this tab will abort the running task. Are you sure you want to abort?',
    tileAbortedDeployments: 'Aborted deployments',
    tileRetriedDeployments: 'Retried deployments',
    tileRollbackDeployments: 'Rollback deployments',
    tileSuccessfulDeployments: 'Successful deployments',
    toLabel: 'to',
    topLongestDeploymentsTitle: 'Top 10 longest deployments',
    topRetriedDeploymentsTitle: 'Top 10 retried deployments',
    topSuccessfulDeploymentsTitle: 'Top 10 successful deployments',
    totalLabel: 'Total',
    typeLabel: 'Type',
    undeployAction: 'Undeploy',
    undeployButton: 'Undeploy',
    undeployFlowTitle: 'Undeploy <%= metadata.application %> <%= metadata.version %> from <%= metadata.environment %>',
    undeployLabel: 'Undeploy',
    undeployment: 'undeployment',
    uniqueNameLabel: 'Please provide a unique name.',
    unknownErrorMessage: 'The application has encountered an unknown error.',
    unknownErrorTitle: 'Error',
    unsavedChangedMessage: 'There are unsaved changes. Are you sure you want to discard these changes?',
    unsavedChangesNotification: 'If you leave now, all unsaved changes will be lost.',
    unskipAllSelectedButton: 'Unskip selected steps',
    unskipButton: 'Unskip',
    untargetedLabel: 'untargeted',
    updateAction: 'Update deployment',
    updateDeployConfigurationTitle: 'Update <%= applicationName %> <%= deployedVersionName %> to <%= newVersionName %>',
    updateFlowTitle: 'Update <%= metadata.application %> <%= metadata.deployedVersionName %> to <%= metadata.newVersionName %>',
    updateLabel: 'Update',
    userLabel: 'User',
    usermanagementTab: 'User management',
    userPlaceholder: 'User',
    validationErrorTitle: 'Validation Error',
    versionColumnTitle: 'Version',
    versionLabel: 'Version <%= version %>',
    viewAsButtonLabel: 'view as',
    viewAsButtonTitle: 'view as <%= data %>',
    viewAsChangeViewButton: 'Change view',
    viewAsClarificationMessage: 'The View As feature is limited to restricting the configuration items which will be displayed. Only configuration items viewable by the selected user or role will be displayed. Other features of XL Deploy are not affected by this setting.',
    viewAsInputLabel: 'Select the type of view to use',
    viewAsOption: 'View as',
    viewAsPopupTitle: 'View as',
    viewAsRolesRadioLabel: 'View as roles',
    viewAsUserInputPlaceholder: 'Select the user...',
    viewAsUserRadioLabel: 'View as user',
    viewDiscoveredCisButton: 'View discovered CIs',
    viewDiscoveredCisFlowTitle: 'Discover <%= ciName %>',
    viewDiscoveredCisTitle: 'View discovered CIs',
    warningsLabel: 'Warnings',
    weeksSuffix: 'wk',
    welcomePanelText: 'Quick tour of the new XL Deploy',
    xebialabsWebsite: 'XebiaLabs website',
    yesButton: 'Yes',
    youCanReopenFromTaskMonitor: 'You can open active tasks from the Task Monitor',
    zeroTimeLabel: '0 sec'
};
