/* eslint-disable max-lines,max-len*/
export default {
    abortButton: 'Abort',
    aboutBoxClasspathTabTitle: 'Server Classpath',
    aboutBoxInstalledPluginsTabTitle: 'Installed Plugins',
    aboutBoxLicenseTabTitle: 'License',
    aboutBoxVersionTabTitle: 'Version',
    aboutOption: 'About',
    aboutToLeaveWithoutSavingMessage: 'You are about to leave without saving. Are you sure?',
    actionsTitle: 'Actions',
    activationListTitle: 'Activation list',
    activeSessionsColumnNameAccessType: 'Access type',
    activeSessionsColumnNameControlTasks: 'Control tasks',
    activeSessionsColumnNameDeploymentTasks: 'Deployment tasks',
    activeSessionsColumnNameUser: 'User',
    activeSessionsControlTasksTotalTitle: 'Control tasks',
    activeSessionsDeploymentTasksTotalTitle: 'Deployment tasks',
    activeSessionsErrorMessage: 'Error while fetching active sessions',
    activeSessionsOverviewTitle: 'Sessions overview',
    activeSessionsTabTitle: 'Active sessions',
    activeSessionsUserTotalTitle: 'Active user sessions',
    addNewRoleLabel: 'New role',
    addNewRowLabel: 'Add new row',
    addNewUserLabel: 'New user',
    adminPermissionTitle: 'admin',
    allPlaceholder: 'All',
    allTasksButton: 'All tasks',
    applicationLabel: 'Application',
    applicationRestrictedDictionaryPopoverText: 'The dictionary has restricted applications',
    applicationsLabel: 'Applications',
    applicationTitle: 'Application',
    applyChangesButton: 'Apply Changes',
    appSummaryEnvironmentsTitle: 'Environments where application is deployed',
    appSummaryLatestDeploymentsTitle: 'Latest deployments',
    appSummaryPipelineTitle: 'Pipeline<% if(name) {%>: <%= name %> <%} %>',
    attemptCounterLabel: '# Attempt nr. <%= attemptNr %>',
    blockLogMessage: 'There is no log output for task blocks. Please select a step to view the log output.',
    cancelButton: 'Cancel',
    cancelCurrentTaskMessage: 'Are you sure you want to cancel the current task?',
    cancelCurrentTaskTitle: 'Cancel current task',
    canceledDeploymentTooltip: 'Cancelled deployment',
    cancelTaskButton: 'Cancel task',
    cannotPromoteMessage: 'Checklist incomplete. Cannot promote to <%= environment %>.',
    cantArchiveMessage: 'The task cannot be archived through the CI Explorer. Please use the Deployment Workspace to archive the task.',
    cantArchiveTitle: 'Can\'t archive',
    cantRenameBodyMessage: 'Cannot rename CI because the new name is empty or contains characters that are not allowed.',
    cantRenameTitle: 'Can\'t rename',
    cantUndeployMessage: 'The package cannot be undeployed through the CI Explorer. Please use the Deployment Workspace to undeploy the package.',
    cantUndeployTitle: 'Can\'t undeploy',
    changedByPlaceholders: 'Changed by <%= user %>',
    changeDictionaryKeyValueMessage: 'You are about to change the <%= placeholderKey %> values in 1 dictionary',
    changeDictionaryKeyValuesMessage: 'You are about to change the <%= placeholderKey %> values in <%= num %> dictionaries',
    changedPlaceholders: 'Changed',
    changeValueTitle: 'Change value',
    checkActiveControlTaskStatusTooltipLabel: 'There is <%= number %> actively running Control task by the user. Click to view tasks.',
    checkActiveDeploymentTaskStatusTooltipLabel: 'There is <%= number %> actively running Deployment task by the user. Click to view tasks.',
    checkConnectionButton: 'Check connection',
    checkControlTaskStatusTooltipLabel: 'Check the task status in the Control task page',
    checklistTitle: 'Checklist for <%= version %> to <%= environment %> <%= pristine ? "" : "*" %>',
    checkTaskStatusLinkLabel: 'Check the task status',
    chooseDeployablesDescription: 'List of deployable to scan for .yaml files for samples.',
    chooseDeployablesLabel: 'Packages',
    chooseDeployablesPlaceholder: 'Type to filter Application list...',
    chooseFileLabel: 'Choose file',
    chooseSampleDescription: 'Add sample that you want to patch',
    chooseSampleSourceLabel: 'Choose sample source',
    ciComparisonTitle: 'Compare <%= ciId %>',
    ciDoesntHaveEditPermissionTooltip: 'You do not have permission to edit this item. Please contact your system administrator.',
    ciDoesntHaveReadPermissionTooltip: 'You do not have permission to see this item. Please contact your system administrator.',
    ciHistoryTitle: 'History of <%= ciId %>',
    ciIdDescription: 'Full item folder structure.',
    ciIdLabel: 'ID: ',
    ciIdPopoverText: 'ID:<%= ciId %>/<%= version %>',
    ciIsDeletedTooltip: 'This item was removed from the system and is not accessible anymore.',
    ciNameDescription: 'The name of the configuration item',
    ciSourceTypeDescription: 'List of packages to scan for files containing samples for patches',
    cisSuccessfullyDeletedMessage: 'CIs successfully deleted',
    ciSuccessfullyDeletedMessage: 'CI successfully deleted',
    ciTypeDescription: 'The type of a configuration item.',
    ciTypeLabel: 'Type: ',
    clearAllErrorMessagesButton: 'Clear all error messages',
    clearAllLabel: 'Clear all',
    clearButton: 'Clear',
    clearButtonTitle: 'Clear all the permissions for this role.',
    closeAllTabsAction: 'Close all tabs',
    closeButton: 'Close',
    closeFlowTitle: 'Leave "<%= flowTitle %>"',
    closeOtherTabsAction: 'Close other tabs',
    closePreviewButton: 'Close preview',
    compareCiHelpText: 'To compare, drag an item from the Library on the left (up to 5 items).',
    compareCiLimitReachedText: 'You can compare up to five configuration items.',
    compareCiLimitWarningText: 'You can compare up to five configuration items. To compare a different item, first remove one.',
    compareMenuProperty: 'Compare',
    compareWithOtherCiAction: 'With other CI',
    compareWithPreviousAction: 'With previous version',
    configurationLabel: 'Configuration',
    configureTitle: 'Configure',
    confirmAndLeave: 'Confirm leave',
    confirmAndLeaveMessage: 'You provided some unsupported values. This may cause issues during deployment. Are you sure you want to leave this page?',
    confirmDeleteCI: 'Are you sure you want to delete ',
    confirmDeleteGenericEntity: 'You are about to delete <%= entityName %>. Are you sure?',
    confirmDeleteRole: 'You are about to delete role <%= name %>. Are you sure?',
    confirmDeleteTitle: 'Confirm Delete',
    confirmDeleteUser: 'You are about to delete user <%= username %>. Are you sure?',
    confirmForceRestartSatellite: 'Forcibly restarting this satellite will cause all active deployment tasks on this satellite to fail. Are you sure you want to proceed?',
    confirmLeaveCiSaveTitle: 'Leave without saving <%= ciName %>?',
    confirmMoveCi: 'Are you sure you want to move <%= sourceCiName %> to <%= targetCiId %>?',
    confirmMoveTitle: 'Confirm move',
    confirmRestartSatellite: 'The satellite will be restarted. If deployment tasks are active, the satellite will restart when the tasks have completed. Are you sure want to proceed?',
    confirmRollback: 'Are you sure you want to roll back the current task?',
    confirmRollbackTitle: 'Roll back current task',
    confirmSaveAndCloseMessage: 'You provided some unsupported values. Are you sure that you want to Save and close?',
    confirmSaveAndCloseTitle: 'Confirm Save and close',
    confirmSaveMessage: 'You provided some unsupported values. Are you sure that you want to Save?',
    confirmSaveTitle: 'Confirm Save',
    connectionLostDescription: 'Enter password to try to log in',
    connectionLostMessage: 'Connection lost',
    containerLabel: 'Container',
    containerRestrictedDictionaryPopoverText: 'The dictionary has restricted containers',
    continueButton: 'Continue',
    controlFlowTitle: 'Control task [<%= metadata.taskLabel %>] for <%= metadata.controlTaskTargetCI %>',
    controlTaskExecutePermissionTitle: 'control task execute',
    controlTasksReportControlTaskNameColumnName: 'Control task name',
    controlTasksReportDescriptionColumnName: 'Description',
    controlTasksReportEndDateColumnName: 'End date',
    controlTasksReportStartDateColumnName: 'Start date',
    controlTasksReportStateColumnName: 'State',
    controlTasksReportTabTitle: 'Control tasks',
    controlTasksReportTargetCIColumnName: 'Target CI',
    controlTasksReportUserColumnName: 'User',
    controlTasksTitle: 'Control tasks',
    copiedLabel: 'Copied',
    copyrightNotice: 'Copyright © XebiaLabs Group. All rights reserved.',
    copyToClipboard: 'Copy to clipboard',
    csvFormatForDeployedApplicationComparison: (appId, lhsName, lhsTimestamp, lhsTaskId, rhsName, rhsTimestamp, rhsTaskId) =>
        `Deployed application version,,"${lhsName} ${lhsTimestamp}","${rhsName} ${rhsTimestamp}"\n,,"ID:${appId}/${lhsName}","ID:${appId}/${rhsName}"\n,,${lhsTaskId}, ${rhsTaskId}\nKey,Container,Values,Values\n`,
    currentColumnName: 'current',
    currentLogMissing: '# (No log output available for this step attempt)',
    currentlyDeployed: '<%= currentlyDeployed %> (currently deployed)',
    currentlyDeployedLabel: 'Currently deployed:',
    currentlyDeployedVersion: '<%= envName %> (currently deployed: <%= currentlyDeployed %>)',
    currentMonthHeader: 'Current month (<%= periodLabel %>)',
    currentVersionTitle: 'Current version values',
    customLabel: 'Custom',
    customSampleOption: 'Custom sample',
    daysSuffix: 'day',
    defaultCredentialExists: 'Default Ci already exists',
    deleteAction: 'Delete',
    deleteButton: 'Delete',
    deleteCiMessage: 'It will be fully removed from XL Deploy.',
    deleteCisMessage: 'Are you sure you want to delete these items?\nYou will not be able to revert this action.',
    deleteCisNotEnoughPermissionsMessage: 'You do not have the permissions required to delete the selected CIs.',
    deleteCisTitle: 'Confirm Delete',
    deleteCiTitle: 'Delete <%= ciName%>?',
    deleteGenericEntityLabel: 'Delete <%= entityName %> ?',
    deleteRoleLabel: 'Delete role <%= name %> ?',
    deleteUserLabel: 'Delete user <%= username %> ?',
    deployablesWithoutPatchableFilesMessage: 'Selected deployables don\'t contain any .json or .yaml file',
    deployAction: 'Deploy',
    deployButton: 'Deploy',
    deployConfigurationTitle: 'Deploy <%= appVersionName %> to <%= environment %>',
    deployedApplicationComparisonTitle: 'Deployments of <%= name %>',
    deployedApplicationVersionColumnApplication: 'Application',
    deployedApplicationVersionDeployed: 'Deployed',
    deployedApplicationVersionTitle: 'Deployed application',
    deployedAppNameTitle: '<%= id%> (<%= version %>)',
    deployedLabel: 'Deployed:',
    deployedPanelPopoverValidationHeader: '<%= count %> <%= type %><% if(count > 1) {%>s<%} %>',
    deployedTitle: 'Deployed',
    deployedValidationNameNotUnique: 'The deployed must have a unique name within the container',
    deployedValidationNotificationMessage: '<%= message %> for <%= property %>',
    deployFlowTitle: 'Deploy <%= metadata.application %> <%= metadata.version %> to <%= metadata.environment %>',
    deployInitialPermissionTitle: 'deploy initial',
    deployLabel: 'Deploy',
    deployLatestAction: 'Deploy latest',
    deployLatestPackageNotFoundToastrMessage: 'Latest package cannot be found',
    deployment: 'deployment',
    deploymentChecklistLabel: 'Deployment checklist',
    deploymentMappingFailureResponseRegex: 'Found (.+) for (.+) and (.+), expected exactly 1. Before filtering we had: (.+)',
    deploymentPanelHeader: '<%= deploymentType %> DEPLOYMENT',
    deploymentPipelineAction: 'Deployment pipeline',
    deploymentPipelineTitle: 'Deployment pipeline',
    deploymentPropertiesButton: 'Deployment Properties',
    deploymentPropertiesTitle: 'Deployment Properties',
    deploymentsReportApplicationsRadioLabel: 'Application(s)',
    deploymentsReportCompletionDateColumnName: 'End Date',
    deploymentsReportDeploymentTypeColumnName: 'Type',
    deploymentsReportEnvironmentColumnName: 'Environment',
    deploymentsReportEnvironmentsRadioLabel: 'Environment(s)',
    deploymentsReportNoneRadioLabel: 'None',
    deploymentsReportPackageColumnName: 'Package(s)',
    deploymentsReportStartDateColumnName: 'Start Date',
    deploymentsReportStatusColumnName: 'State',
    deploymentsReportTabTitle: 'Deployments',
    deploymentsReportUserColumnName: 'User',
    deploymentStatusCancelled: 'Cancelled',
    deploymentStatusDone: 'Done',
    deploymentTasksTitle: 'Deployment tasks',
    deploymentTypeInitial: 'Initial',
    deploymentTypeRollback: 'Rollback',
    deploymentTypeUndeploy: 'Undeploy',
    deploymentTypeUndeployment: 'Undeployment',
    deploymentTypeUpdate: 'Update',
    deploymentTypeUpgrade: 'Upgrade',
    deploymentWorkspaceHelpText: 'To start a deployment, drag a package and an environment here. To perform an update, you can drag a deployed application and a new deployment package.',
    deploymentWorkspaceTitle: 'Deployment Workspace',
    deployUndeployPermissionTitle: 'deploy undeploy',
    deployUpgradePermissionTitle: 'deploy upgrade',
    descriptionLabel: 'Description',
    dictionariesLabel: 'Dictionaries',
    dictionaryLabel: 'Dictionary',
    dictionarySearchPlaceholder: 'Search for dictionaries...',
    dictionaryShowChangesText: 'Show changes',
    disableButton: 'Disable',
    discardChangesAndSaveCisButton: 'Discard changes and save CIs',
    discoverAction: 'Discover',
    discoverButton: 'Discover',
    discoveredCisNoPermissionsMessage: 'You do not have permission to save the discovered CIs',
    discoveredItemsTitle: 'DISCOVERED ITEMS',
    discoverFlowTitle: '<%= description %>',
    discoverTitle: 'Discover',
    discoveryConfigurationFlowTitle: 'Discover <%= ciType %>',
    discoveryPermissionTitle: 'discovery',
    documentLabel: 'Document ',
    doesNotMatchWithXlDeployVersion: 'Different from XL Deploy version',
    doNotDeleteButton: 'Do not delete',
    downloadSupportZipLabel: 'Get data for support',
    dragDropEnvironment: 'Drag and drop environment here',
    dragDropPackage: 'Drag and drop package here',
    duplicateAction: 'Duplicate',
    durationInHours: 'hours',
    durationInMinutes: 'minutes',
    durationInSeconds: 'seconds',
    durationTemplate: '<%= days %>d <%= hours %>h <%= minutes %>m',
    editAction: 'Edit',
    editDeployedItem: 'Edit deployed item',
    editionLabel: 'Edition',
    editPermissionsAction: 'Edit permissions',
    editPropertiesAction: 'Edit properties',
    editRoleLabel: 'Edit <%= name %> role',
    editSelectedButton: 'Edit selected',
    editUserLabel: 'Edit <%= username %> user',
    emptyTargetedLabel: 'targeted (No deployables could be mapped)',
    enableButton: 'Enable',
    enableMaintenanceModeLabel: 'Enable maintenance mode',
    encryptedString: '**********',
    endDateLabel: 'End date',
    environmentColumnInfrastructure: 'Infrastructure',
    environmentColumnLastDeployment: 'Last deployment',
    environmentLabel: 'Environment',
    environmentsLabel: 'Environments',
    environmentSummaryInfrastructureTitle: 'Infrastructure',
    environmentsUnavailableMessage: 'You cannot deploy because there are no environments available',
    environmentTitle: 'Environment',
    envSummaryEditPropertiesButton: 'Edit properties',
    errorTitle: 'Error',
    errorTitleOfRenamingCi: 'Error renaming CI',
    executeButton: 'Execute',
    executionPlanTitle: 'EXECUTION PLAN',
    executionTitle: 'Execution',
    explorerTab: 'Explorer',
    exportAction: 'Export',
    exportReport: 'Export report',
    externalUserLabel: 'External',
    fileTypeLabel: 'File type',
    filterButton: 'Filter',
    filterByLabel: 'Filter by:',
    filterRolesPlaceholder: 'Filter by roles',
    filterUsersPlaceholder: 'Filter by users',
    finishButton: 'Finish',
    finishLabel: 'Finish',
    forceCancel: 'Force cancel',
    forceCancelCurrentTaskMessage: 'This option will cancel the task and ignore any failures on unskippable steps. This could lead to an inconsistency between XL Deploy and your current environment. Are you sure you want to cancel the current task?',
    forceCancelTitle: 'Force cancel task: <%= taskId %>',
    formattedErrorMessage: '<%= message %> for <%= property %> in <%= ciName %>',
    fromLabel: 'from',
    generateDslPermissionTitle: 'generate dsl',
    generatingPreviewText: 'Generating preview...',
    genericToastrErrorTitle: 'Error',
    globalPermissionsTabTitle: 'Global permissions',
    headerDiscovery: 'DISCOVERY',
    headerInitialDeployment: 'INITIAL DEPLOYMENT',
    headerInitialOrUpdateDeployment: 'DEPLOYMENT',
    headerRollbackDeployment: 'ROLLBACK',
    headerUndeployment: 'UNDEPLOYMENT',
    headerUpdateDeployment: 'UPDATE DEPLOYMENT',
    hideButton: 'Hide',
    hideFiltersButton: 'Hide filters',
    hostsLabel: 'Hosts',
    hoursSuffix: 'hr',
    idLabel: 'ID',
    importButton: 'Import',
    importFromComputerAction: 'From computer',
    importFromUrlAction: 'From URL',
    importFromXlDeployServerAction: 'From XL Deploy server',
    importInitialPermissionTitle: 'import initial',
    importMenuProperty: 'Import',
    importPackageCredentialsDescription: 'Choose basic authentication credentials',
    importPackageCredentialsLabel: 'Credentials',
    importPackageFromComputerDescription: 'Package to import.',
    importPackageFromComputerLabel: 'Package',
    importPackageFromComputerTitle: 'Import from computer',
    importPackageFromUrlLabel: 'URL',
    importPackageFromUrlTitle: 'Import from URL',
    importPackageFromXlDeployServerDescription: 'Package to import.',
    importPackageFromXlDeployServerLabel: 'Package',
    importPackageFromXlDeployServerTitle: 'Import from XL Deploy server',
    importPackagePasswordDescription: 'Password to use when importing the package.',
    importPackagePasswordLabel: 'Password',
    importPackageUrlDescription: 'Location of the package (for example, a CI server or artifact repository).',
    importPackageUserDescription: 'User name to use when importing the package.',
    importPackageUserLabel: 'User',
    importRemovePermissionTitle: 'import remove',
    importUpgradePermissionTitle: 'import upgrade',
    incompleteDeploymentWorkspaceTitle: '... to <%= basename %>',
    incompleteInitialDeploymentTitle: 'Deploy <%= appVersionName %> to ...',
    incompleteUpdateDeploymentTitle: 'Update <%= applicationName %> <%= versionName %> to ...',
    incorrectCredentialsDescription: 'Enter correct password to log in',
    incorrectCredentialsMessage: 'The username and/or password you have entered is incorrect.',
    incorrectPasswordMessage: 'The password you have entered is incorrect.',
    infoTitle: 'Information',
    infrastructureLabel: 'Infrastructure',
    infrastructureSummaryEnvironmentColumn: 'Environment',
    infrastructureSummaryEnvironmentsTitle: 'Related to Environments',
    infrastructureSummaryLastDeploymentColumn: 'Last deployment',
    inProgress: 'In progress',
    internalUserLabel: 'Internal',
    invalidCharactersLabel: 'Please enter only valid characters for the Name (no `/`, `\\`, `:`, `[`, `]`, `|`, `,` or `*`)',
    invalidFormat: 'Invalid Format',
    invalidUrlLabel: 'Please enter a valid url',
    issuesInListMessage: 'There are issues in this list',
    keepMeLoggedInLabel: 'Keep me logged in',
    keyColumnName: 'key',
    keyLabel: 'Key',
    last30daysHeader: 'Last 30 days (<%= periodLabel %>)',
    last6monthsHeader: 'Last 6 months (<%= periodLabel %>)',
    lastDeploymentByLabel: '<%= at %> by <%= by %>',
    lastDeploymentLabel: 'Last deployment:',
    lastDeploymentTitle: 'Last deployment (<%= currentlyDeployed %>)',
    lastModifiedAtLabel: '<%= at %> ',
    lastModifiedByLabel: 'by <%= by %>',
    lastUpdatedTimestamp: 'Last updated: <%= timestamp %>',
    leaveAction: 'Leave',
    libraryLabel: 'Library',
    licensedApplicationsLabel: 'Licensed # of Applications',
    licensedContactLabel: 'License contact',
    licenseDescription: 'The limits of your XL Deploy license apply to all instances of XL Deploy that use the license. For compliance purposes, please ensure that the total number of configuration items used in all instances does not exceed the limits of the license.',
    licensedHostsLabel: 'Licensed # of Hosts',
    licensedPluginsLabel: 'Licensed plugins',
    licensedSatellitesLabel: 'Licensed # of Satellites',
    licensedToLabel: 'Licensed to',
    licenseExpiredMessage: 'This XL Deploy server will not function due to a license problem. Please contact your administrator or enter a valid license <a href="productregistration" target="_blank">here</a>.',
    licenseExpiryDateLabel: 'License expires after',
    licenseExpiryWarningMessage: 'Your XL Deploy license expires on <%= expiryDate %>. <a href="productregistration" target="_blank">Register, renew or extend your license.</a>',
    licenseUsage: '<%= licensed %> (in use: <%= inUse %>)',
    lineNotForActivatorMessage: 'Can\'t create activator for selected line.',
    lineNotForPatchMessage: 'Can\'t create patch for selected line.',
    loggedInAsLabel: 'Logged in as',
    loginButton: 'Log in',
    loginPermissionTitle: 'login',
    loginTitle: 'Log in',
    logoutOption: 'Log out',
    lostChangesNotification: 'Are you sure you want to leave? Your changes will be lost.',
    maintenanceModeBannerTextTitle: 'Maintenance mode banner text:',
    maintenanceModeOption: 'Maintenance mode',
    maintenanceModePanelMessage: 'XL Deploy is currently under maintenance. Some actions may not be available. Please try again later.',
    maintenanceModeText: 'Maintenance mode prevents user from starting new deployments, so you can safely restart the XL Deploy server. When you enable maintenance mode, deployments that have already started will be allowed to finish. Use Task Monitor to view deployments that are in progress.',
    maintenanceModeTitle: 'Maintenance mode',
    mapAllDeployables: 'Map all deployables',
    mapDeployables: 'Map deployables',
    metaInformationAction: 'Meta information',
    metaInformationModalTitle: 'Meta information - <%= title %>',
    millisecondsSuffix: 'ms',
    minutesSuffix: 'min',
    modifyPlanButton: 'Modify plan',
    moveAction: 'Move',
    myTasksButton: 'My tasks',
    nameAlreadyInUse: 'Name is already in use',
    nameLabel: 'Name',
    nastatus: 'N/A',
    newAction: 'New',
    newPatchedDictionary: 'Patch Dictionary',
    newRoleAction: 'Add role',
    newTabTitle: 'New Tab',
    newUserAction: 'Add user',
    newValueLabel: 'New value',
    nextButton: 'Next',
    nextColumnName: 'next',
    noButton: 'No',
    noDataActivationListMessage: 'Add match activation rules either by selecting from sample list or by entering key and value',
    noDataAvailableLabel: 'No data available for the current period',
    noDataFilterMessage: 'No data available for the selected filter',
    noDataMessage: 'No data available',
    noDataPatchEntryListMessage: 'Patch dictionaries by selecting path and then action. Available actions are Replace/Edit, Add or Delete',
    noDeploymentsMessage: 'No deployments.',
    noEnvironmentsAssignedToPipelineMessage: 'No environments assigned to the deployment pipeline.',
    noLatestDeploymentsMessage: 'No deployments found in the last 6 months.',
    noLeadingOrTrailingSpaces: (ciName) => `The CI name [${ciName}] must not contain leading or trailing spaces`,
    noLoginPermissions: 'You do not have permission to log in. Please contact your system administrator.',
    noManagedHosts: 'No hosts.',
    noPermissionToDeploymentPipelineEnvironmentsMessage: 'You do not have permission to view all environments in the deployment pipeline for this application.',
    noPermissionToDeploymentPipelineMessage: 'You do not have permission to view the deployment pipeline for this application.',
    noPreviousRevisionsDeployments: 'There are no previous deployments',
    noPreviousRevisionsMessage: 'There are no previous versions',
    noReportsViewPermissionMessage: 'You do not have the `report#view` global permission to see the latest deployments.',
    noRolesAvailableMessage: 'No roles available',
    noSearchResultsText: 'No results found',
    notApplicableLabel: 'Not applicable',
    noteLabel: 'Note:',
    nothingToMapLabel: 'There are no containers in the environment',
    noVersionsMessage: '<%= appName %> does not have any versions.',
    onLabel: 'on',
    onlineDocumentation: 'Online documentation',
    openCIPermissionsTitle: '<%= basename %> permissions',
    openSatelliteOverviewAction: 'Satellites overview',
    openWorkersOverviewAction: 'Workers overview',
    orderLabel: 'Order',
    outOfLabel: '<%= value %> out of <%= total %>',
    overrideDefaultCredential: 'You just selected <%= ciId %> to become the default credential set to be used in XL Deploy, however <%= existingDefaultCiId %> is currently set to be the default credential. Are you sure you want to make this change?',
    packageHasNotFoundMessage: 'Package not found',
    packageLabel: 'Package',
    packagesLabel: 'Packages',
    passwordDescription: 'Type in a password.',
    passwordLabel: 'Password',
    passwordPlaceholder: 'Password',
    pastTimeErrorText: 'Scheduled date and time must be in the future',
    patchActivationDialogCreateButton: 'Create activator',
    patchActivationDialogCreateTitle: 'Add activator',
    patchActivationDialogUpdateButton: 'Update activator',
    patchActivationDialogUpdateTitle: 'Edit activator',
    patchActivationRules: 'Activation rules',
    patchActivationRulesColumnCondition: 'Condition',
    patchActivationRulesColumnConditionDescription: 'Condition for matching the path value',
    patchActivationRulesColumnPath: 'Path',
    patchActivationRulesColumnPathDescription: 'Path to search for in the file',
    patchActivationRulesColumnValue: 'Value',
    patchActivationRulesColumnValueDescription: 'Value that the path must match',
    patchActivationRulesNotDefined: 'No activation rules defined yet',
    patchActivatorLabel: 'activator',
    patchDictionaryNamePlaceholder: 'Patch dictionary name',
    patchDocumentDescription: 'Choose sample file document from which you want to create an activation',
    patchDocumentLabel: 'Document',
    patchedDictionaryModifiedValueTitle: 'Patch',
    patchEditorControlAddToolTip: 'Adds a value to an object or inserts it into an array. In the case of an array, the value is inserted before the given index',
    patchEditorControlDeleteToolTip: 'Removes a value from an object or array',
    patchEditorControlEditToolTip: 'Replaces/Edits a value. Equivalent to a “remove” followed by an “add”',
    patchEditorDescription:
        'Patch dictionaries by selecting path and then action. Available actions are Replace/Edit, Add or Delete',
    patchEntriesColumnAction: 'Action',
    patchEntriesColumnActionDescription: 'Action to take on the path',
    patchEntriesColumnPath: 'Path',
    patchEntriesColumnPathDescription: 'Path to search for in the file',
    patchEntriesColumnValue: 'Value',
    patchEntriesColumnValueDescription: 'Value to use when patching',
    patchEntriesNotDefined: 'No patch entries defined yet',
    patchEntriesTitle: 'Patch entries',
    patchEntryDialogCreateButton: 'Create patch entry',
    patchEntryDialogCreateTitle: 'Add patch entry',
    patchEntryDialogUpdateTitle: 'Edit patch entry',
    patchEntryEditTitle: 'Edit patch entry',
    patchEntryLabel: 'patch entry',
    patchRules: 'Patch rules',
    patchSampleDescription: 'Choose sample file from which you want to create an activation',
    patchSampleLabel: 'Sample',
    patchSelectSample: 'Select Sample',
    pauseAfterButton: 'Pause after',
    pauseBeforeButton: 'Pause before',
    pendingLogMessage: 'There is no log output available for pending steps.',
    permissionsEmptyMessage: 'No permissions available',
    permissionsErrorMessage: 'Error while fetching permissions',
    placeholderApplicationsColumnTitle: 'Applications',
    placeholderDictionaryNameTitle: 'Dictionary',
    placeholderDictionaryValueTitle: 'Value',
    placeholderEnvironmentColumnTitle: 'Environment',
    placeholderManagementLabel: 'Placeholder management',
    placeholdersLabel: 'Placeholders',
    pluginColumnTitle: 'Plugin',
    previewButton: 'Preview',
    previewPermissionNotGivenLabel: 'You do not have permission to preview the step.',
    previewTitle: 'Preview',
    previewUnavailableLabel: 'Preview not available',
    previousButton: 'Previous',
    previousDeploymentsPopoverText: 'View previous deployments',
    previousLogsMissing: '\n\n# (Logs from previous attempts were not recorded)',
    principalsDescription: 'Type in names for principals.',
    principalsTitle: 'Principals',
    productNameLabel: 'Product',
    promoteToNextButton: 'Promote to next environment',
    rateTitle: 'Rate',
    readPermissionTitle: 'read',
    reAuthenticateTitle: 'Re-authenticate',
    referenceLabel: '(Reference)',
    refreshButton: 'Refresh',
    remainingDays: 'days remaining: <%= remainingDays %>',
    removeDeployables: 'Remove deployables',
    removeDeployed: 'Remove deployed',
    removeLabel: 'Remove <%= comparedCi %> from comparison',
    renameAction: 'Rename',
    renamingCiErrorTitle: 'Error renaming CI',
    renewLicenceOption: 'Renew license',
    repoEditPermissionTitle: 'repo edit',
    reportEmptyMessage: 'No report data available for the selected filter',
    reportErrorMessage: 'Error while fetching report',
    reportsDashboardAverageDeploymentAvgDuration: 'Avg.duration: <%= avgDuration %>',
    reportsDashboardAverageDeploymentDurationOverTimeTitle: 'Average deployment duration over time',
    reportsDashboardAverageDeploymentSuccessful: 'Successful: <%= percentageSuccessfulDeployments %>% (<%= noOfSuccessfulDeployments %> deployments)',
    reportsDashboardAverageDeploymentTotalDeployments: 'Deployments: <%= totalDeployments %>',
    reportsDashboardDeploymentStatusOverviewTitle: 'Deployment status overview',
    reportsDashboardTabTitle: 'Dashboard',
    reportsDashboardTopLongestDeploymentsTooltipApplication: 'Application: <%= application %>',
    reportsDashboardTopLongestDeploymentsTooltipDuration: 'Deployment duration: <%= duration %> minutes',
    reportsDashboardTopLongestDeploymentsTooltipEnvironment: 'Environment: <%= environment %>',
    reportsDeploymentOverviewAborted: 'Aborted',
    reportsDeploymentOverviewRetried: 'Retried',
    reportsDeploymentOverviewRollback: 'Rollback',
    reportsDeploymentOverviewSuccessful: 'Successful',
    reportsDeploymentsOverTimeAborted: 'Aborted',
    reportsDeploymentsOverTimeNumberOfDeployments: '# of deployments',
    reportsDeploymentsOverTimeRetried: 'Retried',
    reportsDeploymentsOverTimeRollback: 'Rollback',
    reportsDeploymentsOverTimeSuccessful: 'Successful',
    reportsDeploymentsOverTimeTitle: 'Number of deployments over time',
    reportsTab: 'Reports',
    reportTabDeployments: 'Deployments',
    reportViewPermissionTitle: 'report view',
    requestTimeoutErrorMessage: 'Network Error',
    requestTimeoutMessage: 'Server is taking too long to respond.',
    requestTimeoutTitle: 'Request timeout',
    resetButton: 'Reset',
    resolvedPlaceholders: 'Resolved placeholders',
    resolvedPlaceholdersDeployedLabel: 'Deployed application',
    resolvedPlaceholdersDictionaryLabel: 'Dictionary',
    resolvedPlaceholdersEnvironmentLabel: 'Environment',
    resolvedPlaceholdersHostLabel: 'Target',
    resolvedPlaceholdersKeyLabel: 'Key',
    resolvedPlaceholdersValueLabel: 'Value',
    restartSatelliteLabel: 'Are you sure?',
    retriedTotalTitle: 'Retried/Total #',
    revisionsTitle: 'Revisions:',
    roleDeleteSuccess: 'Role "<%= name %>" deleted',
    roleDescription: 'Provide a unique name for the role.',
    roleExitsLabel: 'Role name <%= name %> already exists',
    roleNameCantBeEmpty: 'Role name cannot be empty',
    rolePrincipalExistsLabel: 'Role principal <%= name %> is already assigned',
    roleRequiredLabel: 'This field is required',
    roleSaveSuccess: 'Role "<%= name %>" created',
    rolesColumnTitle: 'Role',
    rolesTabTitle: 'Roles',
    roleTitle: 'Role',
    rollbackButton: 'Rollback',
    rollbackFlowTitle: 'Roll back <%= metadata.application %> <%= metadata.version %> on <%= metadata.environment %>',
    rollbacklabel: 'Roll back',
    ruleLabel: 'Rule',
    sampleLabel: 'Sample',
    satelliteColumnPluginStatus: 'Plugin status',
    satelliteColumnSatellite: 'Satellite',
    satelliteColumnState: 'State',
    satelliteColumnTarget: 'Target',
    satelliteColumnType: 'Type',
    satelliteColumnVersion: 'Version',
    satelliteConnectionConnected: 'Connected',
    satelliteConnectionDefault: 'Connecting...',
    satelliteConnectionDisconnected: 'Disconnected',
    satelliteConnectionReconnecting: 'Reconnecting...',
    satelliteConnectionRestarting: 'Restarting...',
    satelliteGroupColumnStatus: 'State',
    satelliteGroupEditPropertiesButton: 'Edit properties',
    satelliteGroupRefreshButton: 'Refresh',
    satelliteGroupsFilterLabel: 'Satellite group(s)',
    satelliteGroupsLabel: 'Satellite groups',
    satelliteGroupsSearchLabel: 'Search for satellite group...',
    satelliteGroupsStatusHealthy: 'Healthy',
    satelliteGroupsStatusUnhealthy: 'Unhealthy',
    satelliteOverviewTitle: 'Satellites overview',
    satelliteSatelliteGroupToOverviewLink: 'Check all the satellites in the system',
    satellitesConnected: 'Connected satellites:',
    satellitesDisconnected: 'Disconnected satellites:',
    satellitesEmptyMessage: 'No satellites available for the selected filter',
    satellitesErrorMessage: 'Error while fetching satellites',
    satellitesFilterLabel: 'Satellite(s)',
    satellitesLabel: 'Satellites',
    satellitesSearchLabel: 'Search for satellite...',
    satelliteSummaryEditPropertiesButton: 'Edit properties',
    satelliteSummaryEmptyMessage: 'No tasks available',
    satelliteSummaryErrorMessage: 'Error while fetching satellite tasks',
    satelliteSummaryForceRestartButton: 'Force Restart',
    satelliteSummaryHostsTitle: 'Targets',
    satelliteSummaryPingButton: 'Ping',
    satelliteSummaryRefreshButton: 'Refresh',
    satelliteSummaryRestartButton: 'Restart',
    satelliteSummarySoftRestartButton: 'Soft Restart',
    satelliteSummarySyncButton: 'Sync plugins',
    satelliteSyncStatusOutOfSync: 'Plugins are out of sync',
    satelliteSyncStatusSynchronized: 'Plugins are synchronized',
    satelliteSyncStatusSynchronizing: 'Plugins are synchronizing...',
    satelliteSyncStatusUnknown: 'Unknown status of plugins',
    saveAndCloseButton: 'Save and close',
    saveAndPromoteButton: 'Save and promote',
    saveButton: 'Save',
    saveChangesAndSaveCisButton: 'Save changes and save CIs',
    saveChangesButton: 'Save changes',
    saveCisWithChangesTitle: 'Save CIs with changes?',
    saveDiscoveredCisButton: 'Save discovered CIs',
    saveDiscoveredCisWithChangesMessage: 'You have unsaved changes. Do you want to save them before saving the discovered CIs?',
    saveErrorMessage: 'Your change could not be saved.',
    saveJsonPatchDictionaryWarningMessage: 'Some items have warnings that may prevent correct use.',
    saveSuccessMessage: 'Your change was saved.',
    scheduleButton: 'Schedule',
    scheduleConfirmLabel: 'When would you like to schedule this task?',
    scheduleDateLabel: 'Select the date',
    scheduledDateLabel: 'Scheduled date',
    scheduleFailedMessage: 'Your <%= type %> for <%= date %> at <%= time %> failed.',
    scheduleFailedTitle: 'Schedule failed',
    scheduleLabel: 'Schedule',
    scheduleSucceededMessage: 'Your <%= type %> is scheduled for <%= date %> at <%= time %>.',
    scheduleSucceededTitle: 'Schedule succeeded',
    scheduleTimeLabel: 'Select the time',
    scheduleTitle: 'Schedule',
    scmInfoCommit: 'Commit',
    scmInfoCommittedBy: 'Committed by',
    scmInfoFileName: 'File name',
    scmInfoLabel: 'Source Control Management',
    scmInfoSource: 'Source',
    scmInfoSummary: 'Summary',
    scmInfoTimestamp: 'Timestamp',
    searchByLabel: 'Search by:',
    searchCisLabel: 'CIs',
    searchForDeployedApplicationVersionPlaceholder: 'Search for deployed application...',
    searchForEnvironmentPlaceholder: 'Search for environment...',
    searchForInfrastructurePlaceholder: 'Search for infrastructure...',
    searchForSatellitePlaceholder: 'Search for satellite...',
    searchPlaceholder: 'Search',
    secondsSuffix: 'sec',
    securityEditPermissionTitle: 'security edit',
    selectAllLabel: 'Select all',
    selectDictionaryText: ' dictionaries selected',
    selectDiscoveredItemLabel: 'Click a discovered item to view or edit properties',
    selectEnvironmentTitle: 'Select Environment',
    selectOneDictionaryText: '<strong>1</strong> dictionary selected',
    selectVersionPlaceholder: 'Select Package',
    selectVersionTitle: 'Select Package',
    separatorFirstLabel: 'Separator1',
    separatorSecondLabel: 'Separator2',
    serverVersion: 'Server version: <%= serverVersion %>',
    sessionExpiredDescription: 'Enter password to continue the session',
    sessionExpiredMessage: 'Session expired',
    showAllItems: 'Show all <%= numOfItems %>',
    showButton: 'Show',
    showFiltersButton: 'Show filters',
    showFullReportLabel: 'Show full report',
    showLessItems: 'Show less',
    skipAllSelectedButton: 'Skip selected steps',
    skipButton: 'Skip',
    sourcePathLabel: 'Source path',
    sourceTypeDescription: 'Select sample source type',
    sourceTypeLabel: 'Source type',
    stageConfigure: 'Configure',
    stageExecution: 'Execution',
    stageRollback: 'Rollback',
    startDateLabel: 'Start date',
    startDeploymentButton: 'Start a deployment',
    startLabel: 'Start',
    stateLabel: 'State',
    stayOnPageButton: 'Stay on the page',
    stepLogMessage: 'There is no log output available for a <%= state %> step.',
    stepNumberLabel: 'Step number',
    stepScriptTitle: 'Step preview',
    stopButton: 'Stop',
    strictToOptionValidationMessage: 'You have to select a value from the dropdown menu',
    submitSupportRequest: 'Submit a support request',
    successfulDeploymentTooltip: 'Successful deployment',
    successfulImport: 'Imported successfully',
    successTitle: 'Success',
    successTotalTitle: 'Success/Total #',
    suggestFeature: 'Suggest a feature',
    supportPolicyLabel: 'Support policy',
    tableLoadingMessage: 'Data loading… This process may take some time.',
    tableTotals: 'Total: <%= total %>',
    targetedLabel: 'targeted',
    targetLabel: 'Target',
    taskArchivedNotAllowedInExecutionViewMessage: 'You can not view archived task in execution view',
    taskAssignPermissionTitle: 'task assign',
    taskAssignTitle: 'Assign task: <%= taskId %>',
    taskAssignToLabel: 'Assign to',
    taskAssignToMe: 'Assign to me',
    taskAssignToUser: 'Assign to user...',
    taskAssignToUserDescription: 'Select the user you would like to assign this task to.',
    taskColumnNameEnvironment: 'Environment',
    taskColumnNamePackage: 'Package(s)',
    taskColumnNameStartDate: 'Start date',
    taskColumnNameStatus: 'State',
    taskColumnNameTaskType: 'Type',
    taskColumnNameUser: 'User',
    taskIdLabel: 'Task ID',
    taskIdTitle: 'Task ID - <%= taskId %>',
    taskMonitor: 'Task Monitor',
    taskMonitorErrorMessage: 'Error while fetching tasks',
    taskMoveStepPermissionTitle: 'task move step',
    taskNameLabel: 'Task name',
    taskOpenPermissionNotGivenLabel: 'You do not have permission to view this task',
    taskPreviewStepPermissionTitle: 'task preview step',
    tasksEmptyFilterMessage: 'No tasks available for the selected filter',
    tasksEmptyMessage: 'No tasks available',
    tasksErrorMessage: 'Error while fetching tasks',
    taskSkipStepPermissionTitle: 'task skip step',
    tasksLabel: 'Tasks',
    taskSuccessfullyAssignedToUser: 'The task was successfully assigned to <%= newUser %>',
    taskSuccessfullyCancelled: 'The task was successfully cancelled',
    taskTakeoverPermissionTitle: 'task takeover',
    taskUnarchivedControlTaskInDeploymentsViewNotAllowedMessage: 'You can not view control task in deployments view',
    taskUnarchivedDeploymentTaskInControlTasksViewNotAllowedMessage: 'You can not view deployment task in control tasks view',
    taskViewPermissionTitle: 'task view',
    taskWillBeAbortedNotification: 'Closing this tab will abort the running task. Are you sure you want to abort?',
    tileAbortedDeployments: 'Aborted deployments',
    tileRetriedDeployments: 'Retried deployments',
    tileRollbackDeployments: 'Rollback deployments',
    tileSuccessfulDeployments: 'Successful deployments',
    toLabel: 'to',
    topLongestDeploymentsTitle: 'Top 10 longest deployments',
    topRetriedDeploymentsTitle: 'Top 10 retried deployments',
    topSuccessfulDeploymentsTitle: 'Top 10 successful deployments',
    totalLabel: 'Total',
    typeLabel: 'Type',
    undeployAction: 'Undeploy',
    undeployButton: 'Undeploy',
    undeployFlowTitle: 'Undeploy <%= metadata.application %> <%= metadata.version %> from <%= metadata.environment %>',
    undeployLabel: 'Undeploy',
    undeployment: 'undeployment',
    uniqueNameLabel: 'Please provide a unique name.',
    unknownErrorMessage: 'The application has encountered an unknown error.',
    unknownErrorTitle: 'Error',
    unsavedChangedMessage: 'There are unsaved changes. Are you sure you want to discard these changes?',
    unsavedChangesNotification: 'If you leave now, all unsaved changes will be lost.',
    unskipAllSelectedButton: 'Unskip selected steps',
    unskipButton: 'Unskip',
    untargetedLabel: 'untargeted',
    updateAction: 'Update deployment',
    updateDeployConfigurationTitle: 'Update <%= applicationName %> <%= deployedVersionName %> to <%= newVersionName %>',
    updateFlowTitle: 'Update <%= metadata.application %> <%= metadata.deployedVersionName %> to <%= metadata.newVersionName %>',
    updateLabel: 'Update',
    updatePatchEntryButton: 'Update patch entry',
    userDeleteSuccess: 'User "<%= username %>" deleted',
    userLabel: 'User',
    usermanagementTab: 'User management',
    usernameDescription: 'Provide a unique username for the user.',
    usernameLabel: 'Username',
    userPlaceholder: 'User',
    userSaveSuccess: 'User "<%= username %>" created',
    usersEmptyMessage: 'No users available',
    usersErrorMessage: 'Error while fetching users',
    usersTabTitle: 'Users',
    validationErrorTitle: 'Validation Error',
    versionColumnTitle: 'Version',
    versionLabel: 'Version: <%= version %>',
    viewAllCisLabel: 'View all CIs',
    viewAsButtonLabel: 'view as',
    viewAsButtonTitle: 'view as <%= data %>',
    viewAsChangeViewButton: 'Change view',
    viewAsClarificationMessage: 'The View As feature is limited to restricting the configuration items which will be displayed. Only configuration items viewable by the selected user or role will be displayed. Other features of XL Deploy are not affected by this setting.',
    viewAsInputLabel: 'Select the type of view to use',
    viewAsOption: 'View as',
    viewAsPopupTitle: 'View as',
    viewAsRolesRadioLabel: 'View as roles',
    viewAsUserInputPlaceholder: 'Select the user...',
    viewAsUserRadioLabel: 'View as user',
    viewDifferencesButton: 'View Differences',
    viewDifferencesTitle: 'View Differences',
    viewDiscoveredCisButton: 'View discovered CIs',
    viewDiscoveredCisFlowTitle: 'Discover <%= ciName %>',
    viewDiscoveredCisTitle: 'View discovered CIs',
    viewLabel: 'View',
    warningsLabel: 'Warnings',
    warningTitle: 'Warning',
    weeksSuffix: 'wk',
    welcomePanelText: 'Quick tour of the new XL Deploy',
    workerAddressTitle: 'Address',
    workerConnectionConnected: 'Connected',
    workerConnectionDisconnected: 'Disconnected',
    workerConnectionDraining: 'Draining',
    workerConnectionIncompatible: 'Incompatible',
    workerLabel: 'Worker',
    workerNameTitle: 'Name',
    workerRemoveFromList: 'Remove from list',
    workerRemoveFromListConfirmDialog: 'Are you sure you want to remove this worker from the list?',
    workersAddressFilter: 'Address',
    workersColumnAddress: 'Worker address',
    workersColumnControlTasks: 'Control tasks',
    workersColumnDeploymentTasks: 'Deployment tasks',
    workersColumnId: 'ID',
    workersColumnName: 'Worker name',
    workersColumnState: 'State',
    workersEmptyMessage: 'No workers available',
    workersErrorMessage: 'Error while fetching workers',
    workerShutdown: 'Shut down',
    workersIdFilter: 'ID',
    workersNameFilter: 'Name',
    workersOverviewTitle: 'Workers overview',
    xebialabsWebsite: 'XebiaLabs website',
    yesButton: 'Yes',
    youCanReopenFromTaskMonitor: 'You can open active tasks from the Task Monitor',
    zeroTimeLabel: '0 sec'
};
