#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

context.addStep(steps.os_script(
    description="Login into Cloud Foundry server [{}]".format(deployed.container.container.server.apiEndpoint),
    order=55,
    script="cf/cf-login",
    freemarker_context={'cfclient': deployed.container.container.server},
    target_host=deployed.container.container.server.host
))

context.addStepWithCheckpoint(steps.jython(
    description="Push [{}] on [{}] space".format(deployed.appName, deployed.container.spaceName),
    order=57,
    script="cf/push.py",
    jython_context={"cfclient": deployed.container.container.server},
    preview_script="cf/preview_push.py"
), delta)

context.addStep(steps.os_script(
    description="Logout from Cloud Foundry server [{}]".format(deployed.container.container.server.apiEndpoint),
    order=59,
    script="cf/cf-logout",
    freemarker_context={'cfclient': deployed.container.container.server},
    target_host=deployed.container.container.server.host
))
