#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from cf.cf_executor import CfExecutor

deployed = CfExecutor.set_cf_path_from_dict(deployed, deployedApplication)

context.addStep(steps.jython(
    description="Login into Cloud Foundry server [{}]".format(deployed.container.container.apiEndpoint),
    order=55,
    script="cf/cf_login.py",
    jython_context={"deployed": deployed.container},
    preview_script="cf/preview_login.py"
))

context.addStepWithCheckpoint(steps.jython(
    description="Create service [{}] on space [{}]".format(deployed.name, deployed.container.spaceName),
    order=57,
    script="cf/service/create_service.py",
    jython_context={"deployed": deployed, "container": deployed.container.container},
    preview_script="cf/service/planningScripts/preview_create_service.py"
), delta)

context.addStep(steps.jython(
    description="Logout from Cloud Foundry server [{}]".format(deployed.container.container.apiEndpoint),
    order=59,
    script="cf/cf_logout.py",
    jython_context={"deployed": deployed.container},
    preview_script="cf/preview_logout.py"
))