#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from cf.generator import Generator
from subprocess import Popen, PIPE

class CfExecutor:

    @staticmethod
    def executeWithoutPrint(command):
        process = Popen(args=command,stdout=PIPE,stderr=PIPE,shell=True)
        stdout, stderr = process.communicate()
        if len(stderr) > 0:
            print("Failed with error: {}".format(stderr))
            print(stderr)
            exit(1)

    @staticmethod
    def executeControlTasks(ci, command):
        cf_login = Generator(ci.container.container).generate_login_command(ci.container.container.apiEndpoint, ci.container.container.username, ci.container.container.password, ci.container.container.organizationName, ci.container.container.defaultSpaceName)
        cf_logout = Generator(ci.container.container).generate_logout_command()
        CfExecutor.executeWithoutPrint(cf_login)
        CfExecutor.execute(command)
        CfExecutor.executeWithoutPrint(cf_logout)

    @staticmethod
    def execute(command):
        process = Popen(args=command,stdout=PIPE,stderr=PIPE,shell=True)
        stdout, stderr = process.communicate()
        if len(stderr) == 0:
            print(stdout)
        else:
            if "Instances starting" in stderr or "Deprecation warning" in stderr:
                print(stdout)
            else:
                print("Failed with error: {}".format(stderr))
                print(stderr)
                exit(1)

    @staticmethod
    def set_cf_path_from_dict(deployed, deployedApplication):
        for dictionary in deployedApplication.environment.dictionaries:
            for entry in dictionary.entries:
                if entry == "cfHome":
                    deployed.container.container.cfHome = dictionary.entries[entry]
                if entry == "cliVersion":
                    deployed.container.container.cliVersion = dictionary.entries[entry]
        return deployed
