from cf.app.helpers.app_helper import AppHelper
from cf.app.route.helpers.route_helper import RouteHelper
from cf.space.helpers.space_helper import SpaceHelper

from cf.app.helpers.app_steps_helper import AppStepsHelper

app_steps_helper = AppStepsHelper(context, steps, delta, SpaceHelper.get_space_name(deployed.container))
if AppHelper.get_app_name(deployed) != AppHelper.get_app_name(previousDeployed):
    raise RuntimeError("App name cannot be modified")

app_name = AppHelper.get_app_name(deployed)

if bool(deployed.rollingUpdate):
    new_app_name = "{}-green".format(app_name)
    app_steps_helper.add_steps_for_unbinding_routes(previousDeployed.routes, deployed.routes,
                                                    previousDeployed.container, app_name, True)
    app_steps_helper.add_step_for_rename_app(deployed.container, app_name, new_app_name)
    app_steps_helper.add_step_for_create_app(deployed)
    for bound_service in deployed.boundServices:
        app_steps_helper.add_step_for_bind_service(deployed.container, bound_service, app_name)
    app_steps_helper.add_steps_for_binding_routes(previousDeployed.routes, deployed.routes, deployed.container, app_name)
    app_steps_helper.add_step_for_start_app(deployed.container, app_name)
    for route in previousDeployed.routes:
        if RouteHelper.contains_route(deployed.routes, route):
            app_steps_helper.add_step_for_unbind_route(previousDeployed.container, route, new_app_name, True)
    for boundService in previousDeployed.boundServices:
        app_steps_helper.add_step_for_unbind_service(previousDeployed.container, boundService, new_app_name, True)
    app_steps_helper.add_step_for_stop_app(previousDeployed.container, new_app_name, True)
    app_steps_helper.add_step_for_destroy_app(previousDeployed.container, new_app_name, True)
else:
    app_steps_helper.add_steps_for_unbinding_routes(previousDeployed.routes, deployed.routes,
                                                    previousDeployed.container, app_name)
    for boundService in previousDeployed.boundServices:
        if not AppHelper.contains_bound_service(deployed.boundServices, boundService):
            app_steps_helper.add_step_for_unbind_service(previousDeployed.container, boundService, app_name)
    app_steps_helper.add_step_for_stop_app(deployed.container, app_name)
    app_steps_helper.add_step_for_modify_app(deployed)
    for bound_service in deployed.boundServices:
        if not AppHelper.contains_bound_service(previousDeployed.boundServices, boundService):
            app_steps_helper.add_step_for_bind_service(deployed.container, bound_service, app_name)
    app_steps_helper.add_steps_for_binding_routes(previousDeployed.routes, deployed.routes, deployed.container, app_name)
    app_steps_helper.add_step_for_start_app(deployed.container, app_name)
