class ServicesHelper(object):
    @staticmethod
    def get_service_instance_name(deployed):
        return deployed.serviceInstanceName if deployed.serviceInstanceName else deployed.name

    @staticmethod
    def get_service_key_name(service_key):
        return service_key.serviceKeyName if service_key.serviceKeyName else service_key.name

    @staticmethod
    def get_service_keys_changes(deployed_service_keys, previous_deployed_service_keys):
        newMap = {ServicesHelper.get_service_key_name(deployed_service_key): deployed_service_key for
                  deployed_service_key in deployed_service_keys}
        oldMap = {ServicesHelper.get_service_key_name(deployed_service_key): deployed_service_key for
                  deployed_service_key in previous_deployed_service_keys}
        return ServicesHelper.get_changes(newMap, oldMap)

    @staticmethod
    def get_changes(new_map, old_map):
        added = [new_map[newKey] for newKey in new_map.keys() if (newKey not in old_map)]
        removed = [old_map[oldKey] for oldKey in old_map.keys() if (oldKey not in new_map)]
        modified_key_names = [oldKey for oldKey in old_map.keys() if
                              (oldKey in new_map and ServicesHelper.has_parameters_changed(new_map[oldKey].parameters,
                                                                                           old_map[oldKey].parameters))]
        return added + [new_map[key] for key in modified_key_names], removed + [old_map[key] for key in
                                                                                modified_key_names]

    @staticmethod
    def has_parameters_changed(old_parameters, new_parameters):
        if bool(old_parameters) != bool(new_parameters):
            return True
        if len(old_parameters) != len(new_parameters):
            return True
        if bool(old_parameters):
            for key, value in old_parameters.iteritems():
                if key not in new_parameters:
                    return True
                elif value != new_parameters[key]:
                    return True

    @staticmethod
    def has_service_tags_changed(old_tags, new_tags):
        if bool(old_tags) != bool(new_tags):
            return True
        if len(old_tags) != len(new_tags):
            return True
        for tag in old_tags:
            if tag not in new_tags:
                return True
