from cf.services.helpers.services_helper import ServicesHelper
from cf.space.helpers.space_helper import SpaceHelper


class ServicesStepHelper(object):
    def __init__(self, context, steps, delta, deployed, previous_deployed=None):
        self.__context = context
        self.__steps = steps
        self.__delta = delta
        self.__deployed = deployed
        self.__previous_deployed = previous_deployed

    def add_create_services_step(self):
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Create service {} on {}".format(
                ServicesHelper.get_service_instance_name(self.__deployed),
                SpaceHelper.get_space_name(self.__deployed.container)),
            script="cf/services/create_services.py",
            order=70
        ), self.__delta)

    def add_modify_services_step(self):
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Modify service {} on {}".format(
                ServicesHelper.get_service_instance_name(self.__deployed),
                SpaceHelper.get_space_name(self.__previous_deployed.container)),
            script="cf/services/modify_services.py",
            order=70
        ), self.__delta)

    def add_destroy_services_step(self):
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Destroy service {} on {}".format(
                ServicesHelper.get_service_instance_name(self.__previous_deployed),
                SpaceHelper.get_space_name(self.__previous_deployed.container)),
            script="cf/services/destroy_services.py",
            order=30
        ), self.__delta)


    def add_create_service_key_step(self, service_key_name, parameters):
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Create service key {} on service {}".format(service_key_name,
                                                                     ServicesHelper.get_service_instance_name(
                                                                         self.__deployed)),
            script="cf/services/create_service_key.py",
            jython_context={"deployed": self.__deployed, "serviceKeyName": service_key_name,
                            "parameters": parameters},
            order=73
        ), self.__delta)

    def add_delete_service_key_step(self, service_key_name):
        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Destroy service key {} on service {}".format(service_key_name,
                                                                      ServicesHelper.get_service_instance_name(
                                                                          self.__previous_deployed)),
            script="cf/services/delete_service_key.py",
            jython_context={"deployed": self.__deployed, "previousDeployed": self.__previous_deployed,
                            "serviceKeyName": service_key_name},
            order=27
        ), self.__delta)
