#
# Copyright 2017 XEBIALABS
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

from cf.client import OrgClient, SpaceClient
import sys

def new_instance(id, ci_type):
    return Type.valueOf(ci_type).descriptor.newInstance(id)


def reverse_engineer_space(cf_space, org_id):
    space_ci = new_instance("%s/%s" % (org_id, cf_space.name), "cloudFoundry.Space")
    space_ci.setProperty("spaceName", cf_space.name)
    print("Recording space %s in repository" % str(space_ci))
    inspectionContext.discovered(space_ci)
    inspectionContext.inspected(space_ci)
    print "Space [%s] has been discovered" % cf_space.name


def find_app_buildpack(manifest):
    print ("Finding buildpack from manifest %s" % manifest)
    buildpack_url = manifest.buildpack
    buildpack = "Custom"
    if buildpack_url == "https://github.com/cloudfoundry/binary-buildpack.git":
        buildpack = "Binary"
    elif buildpack_url == "https://github.com/cloudfoundry/hwc.git":
        buildpack = "HWC"
    elif buildpack_url == "https://github.com/cloudfoundry/go-buildpack.git":
        buildpack = "Go"
    elif buildpack_url == "https://github.com/cloudfoundry/java-buildpack.git":
        buildpack = "Java"
    elif buildpack_url == "https://github.com/cloudfoundry/dotnet-core-buildpack.git":
        buildpack = ".Net"
    elif buildpack_url == "https://github.com/cloudfoundry/nodejs-buildpack.git":
        buildpack = "Node.js"
    elif buildpack_url == "https://github.com/cloudfoundry/nginx-buildpack.git":
        buildpack = "NGINX"
    elif buildpack_url == "https://github.com/cloudfoundry/php-buildpack.git":
        buildpack = "PHP"
    elif buildpack_url == "https://github.com/cloudfoundry/python-buildpack.git":
        buildpack = "Python"
    elif buildpack_url == "https://github.com/cloudfoundry/r-buildpack.git":
        buildpack = "R"
    elif buildpack_url == "https://github.com/cloudfoundry/ruby-buildpack.git":
        buildpack = "Ruby"
    elif buildpack_url == "https://github.com/cloudfoundry/staticfile-buildpack.git":
        buildpack = "Staticfile"
    print("Buildpack detected: %s, %s" % (buildpack_url, buildpack))
    return buildpack


def reverse_engineer_apps(organization, space):
    space_client = SpaceClient.create_space_discovery_client(organization, space)
    applications = space_client.discover_applications()
    print("Applications:")
    print(str(applications))
    for app in applications:
        print(str(app))
        manifest=space_client.get_application_manifest(app.name)
        app_ci=new_instance("%s/%s/%s" % (organization.id, space.name, app.name), "cloudFoundry.App")
        app_ci.setProperty("appName", app.name)
        buildpack = find_app_buildpack(manifest)
        app_ci.setProperty("buildPack", buildpack)
        if buildpack == "Custom":
            app_ci.setProperty("customBuildPackURL", manifest.buildpack)
        if manifest.randomRoute:
            app_ci.setProperty("randomRoute", manifest.randomRoute)
        if manifest.noRoute:
            app_ci.setProperty("noRoute", manifest.noRoute)
        #discover routes
        if manifest.routes:
            for cf_route in manifest.routes:
                route=str(cf_route.route)
                print(route)
                #route=route.split("=",1)[1][:-1]
                route_ci=new_instance("%s/%s/%s/%s" % (organization.id, space.name, app.name, route), "cloudFoundry.Route")
                route_ci.setProperty("domainName", route.split(".", 1)[1])
                inspectionContext.discovered(route_ci)
                inspectionContext.inspected(route_ci)
        #discover bound services
        if manifest.services:
            for cf_service in manifest.services:
                service=str(cf_service)
                print(service)
                #service=service.split("=",1)[1][:-1]
                service_ci=new_instance("%s/%s/%s/%s" % (organization.id, space.name, app.name, service), "cloudFoundry.BoundService")
                inspectionContext.discovered(service_ci)
                inspectionContext.inspected(service_ci)
        app_ci.setProperty("memory", app.diskQuota)
        app_ci.setProperty("instances", manifest.instances)
        app_ci.setProperty("urls", app.urls)
        app_ci.setProperty("appId", app.id)
        inspectionContext.discovered(app_ci)
        inspectionContext.inspected(app_ci)


cf_client = OrgClient.create_discovery_client(thisCi)

if cf_client is None:
        sys.exit("Could not connect to cloudfoundry organization")

#discover spaces
spaces = cf_client.discover_spaces()

for space in spaces:
    #register each space and its corresponding applications
    reverse_engineer_space(space, thisCi.id)
    reverse_engineer_apps(thisCi, space)



