import yaml
from java.io import File

class ManifestHelper(object):

    @staticmethod
    def get_applications_names(deployed):
        yaml_path = ManifestHelper.get_manifest_path(deployed)
        with open(yaml_path, 'r') as stream:
            app_names = []
            for app in yaml.load(stream)['applications']:
                app_names.append(app['name'])
            return app_names

    @staticmethod
    def get_manifest_path(deployed):
        return "{}{}{}".format(deployed.file.path,File.separator,deployed.manifestFileName)
