from cf.space.helpers.space_helper import SpaceHelper
from cf.manifest import ManifestHelper

context.addStepWithCheckpoint(steps.jython(
    description="Create {} on {}".format(deployed.name, deployed.container.spaceName or deployed.container.name),
    script="cf/manifest/create.py",
    order=81
), delta)

for app_name in ManifestHelper.get_applications_names(deployed):
    context.addStepWithCheckpoint(steps.jython(
        description="Start {} on {}".format(app_name, deployed.container.spaceName or deployed.container.name),
        script="cf/app/start_app.py",
        jython_context={"container": deployed.container, "spaceName": SpaceHelper.get_space_name(deployed.container), "appName": app_name},
        order=82
    ), delta)
