from cf.client import OrgClient


class SpaceHelper(object):

    def __init__(self, container):
        self.org_client = OrgClient.create_client(container)

    @staticmethod
    def get_space_name(deployed):
        return deployed.spaceName if deployed.spaceName else deployed.name

    def create_space(self, deployed):
        print "Creating {} on {}" \
            .format(self.get_space_name(deployed), deployed.container.organizationName)
        self.org_client.create_space(self.get_space_name(deployed))

    def destroy_space(self, deployed):
        print "Destroying {} from {}" \
                    .format(self.get_space_name(deployed), deployed.container.organizationName)
        self.org_client.delete_space(self.get_space_name(deployed))

    def modify_space(self, deployed, previousDeployed):
        print "Renaming {} to {} on {}" \
            .format(self.get_space_name(previousDeployed), self.get_space_name(deployed), deployed.container.organizationName)
        self.org_client.rename_space(self.get_space_name(previousDeployed),
                                     self.get_space_name(deployed))



