from cf.space.helpers.space_helper import SpaceHelper
from cf.manifest import ManifestHelper

for app_name in ManifestHelper.get_applications_names(previousDeployed):
    context.addStep(steps.jython(
        description="Stop {} on {}".format(app_name, SpaceHelper.get_space_name(previousDeployed.container)),
        script="cf/app/stop_app.py",
        jython_context={"container": previousDeployed.container, "spaceName": SpaceHelper.get_space_name(previousDeployed.container), "appName": app_name},
        order=11
    ))

for app_name in set(ManifestHelper.get_applications_names(previousDeployed)) - set(ManifestHelper.get_applications_names(deployed)):
    context.addStepWithCheckpoint(steps.jython(
        description="Destroy {} from {}".format(app_name, previousDeployed.container.spaceName or previousDeployed.container.name),
        script="cf/app/destroy_app.py",
        jython_context={"container": previousDeployed.container, "spaceName": SpaceHelper.get_space_name(previousDeployed.container), "appName": app_name},
        order=12
    ), delta)


context.addStepWithCheckpoint(steps.jython(
    description="Update {} on {}".format(deployed.name, SpaceHelper.get_space_name(previousDeployed.container)),
    script="cf/manifest/modify.py",
    order=83
), delta)


for app_name in ManifestHelper.get_applications_names(deployed):
    context.addStep(steps.jython(
        description="Start {} on {}".format(app_name, SpaceHelper.get_space_name(previousDeployed.container)),
        script="cf/app/start_app.py",
        jython_context={"container": deployed.container, "spaceName": SpaceHelper.get_space_name(deployed.container), "appName": app_name},
        order=84
    ))

