from cf.services.helpers.services_helper import ServicesHelper
from cf.services.helpers.services_step_helper import ServicesStepHelper

if ServicesHelper.get_service_instance_name(deployed) != ServicesHelper.get_service_instance_name(previousDeployed):
    raise RuntimeError("Service name cannot be modified")

services_step_helper = ServicesStepHelper(context, steps, delta, deployed, previousDeployed)
service_keys_added, service_keys_deleted = ServicesHelper.get_service_keys_changes(deployed.serviceKeys,
                                                                                   previousDeployed.serviceKeys)
if bool(service_keys_deleted):
    for service_key in service_keys_deleted:
        services_step_helper.add_delete_service_key_step(ServicesHelper.get_service_key_name(service_key))
if deployed.planName != previousDeployed.planName or ServicesHelper.has_service_tags_changed(deployed.serviceTags,
                                                                                             previousDeployed.serviceTags) or ServicesHelper.has_parameters_changed(
    deployed.parameters, previousDeployed.parameters):
    services_step_helper.add_modify_services_step()
if bool(service_keys_added):
    for service_key in service_keys_added:
        services_step_helper.add_create_service_key_step(ServicesHelper.get_service_key_name(service_key),
                                                         service_key.parameters)
