/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.services;

import com.amazonaws.service.codepipeline.AWSCodePipelineClient;
import com.amazonaws.service.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.service.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.service.codepipeline.model.ActionCategory;
import com.amazonaws.service.codepipeline.model.ActionOwner;
import com.amazonaws.service.codepipeline.model.ActionType;
import com.amazonaws.service.codepipeline.model.ActionTypeId;
import com.amazonaws.service.codepipeline.model.ExecutionDetails;
import com.amazonaws.service.codepipeline.model.FailureDetails;
import com.amazonaws.service.codepipeline.model.FailureType;
import com.amazonaws.service.codepipeline.model.Job;
import com.amazonaws.service.codepipeline.model.JobStatus;
import com.amazonaws.service.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.service.codepipeline.model.ListActionTypesResult;
import com.amazonaws.service.codepipeline.model.PollForJobsRequest;
import com.amazonaws.service.codepipeline.model.PollForJobsResult;
import com.amazonaws.service.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.service.codepipeline.model.PutJobSuccessResultRequest;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.plugin.codepipeline.helpers.S3Helper;
import com.xebialabs.deployit.plugin.codepipeline.helpers.Validator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodePipelineJobService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodePipelineJobService.class);
    private final AWSCodePipelineClient codePipelineClient;
    private String version;

    public CodePipelineJobService(AWSCodePipelineClient codePipelineClient) {
        Validator.notNull(codePipelineClient);
        this.codePipelineClient = codePipelineClient;
    }

    public Job getJob(String xlDeployServerKey) {
        ActionTypeId actionTypeId = this.getActionTypeId();
        LOGGER.info("PollForJobs for action type {}", (Object)actionTypeId);
        PollForJobsRequest pollForJobsRequest = new PollForJobsRequest();
        pollForJobsRequest.setActionTypeId(actionTypeId);
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("XL Deploy Server Key", xlDeployServerKey);
        pollForJobsRequest.setQueryParam(queryParam);
        pollForJobsRequest.setMaxBatchSize(Integer.valueOf(1));
        PollForJobsResult pollForJobsResult = this.codePipelineClient.pollForJobs(pollForJobsRequest);
        LOGGER.info("Found {} job(s)", (Object)pollForJobsResult.getJobs().size());
        if (!pollForJobsResult.getJobs().isEmpty()) {
            return (Job)pollForJobsResult.getJobs().get(0);
        }
        return null;
    }

    public JobStatus acknowledgeJob(Job job) {
        LOGGER.info("AcknowledgeJob for job '{}' and nonce '{}'", (Object)job.getId(), (Object)job.getNonce());
        AcknowledgeJobRequest request = new AcknowledgeJobRequest();
        request.setJobId(job.getId());
        request.setNonce(job.getNonce());
        AcknowledgeJobResult result = this.codePipelineClient.acknowledgeJob(request);
        return JobStatus.valueOf((String)result.getStatus());
    }

    public void sendJobSuccessStatus(Job job, String message) {
        LOGGER.info("PutJobSuccessResult for job '{}'", (Object)job.getId());
        PutJobSuccessResultRequest request = new PutJobSuccessResultRequest();
        request.setJobId(job.getId());
        ExecutionDetails executionDetails = new ExecutionDetails();
        executionDetails.setSummary(message);
        request.setExecutionDetails(executionDetails);
        this.codePipelineClient.putJobSuccessResult(request);
    }

    public boolean hasArtifact(Job job) {
        return !job.getData().getInputArtifacts().isEmpty();
    }

    public Map<String, String> getJobData(Job job) {
        return job.getData().getActionConfiguration().getConfiguration();
    }

    public String getJobData(Job job, String key) {
        return this.getJobData(job).get(key);
    }

    public Path getPackagePath(Job job) {
        return S3Helper.downloadPackageFromJob(job);
    }

    public void sendJobFailureStatus(Job job, String message) {
        LOGGER.info("PutJobFailureResult for job '{}'", (Object)job.getId());
        PutJobFailureResultRequest request = new PutJobFailureResultRequest();
        request.setJobId(job.getId());
        FailureDetails failureDetails = new FailureDetails();
        failureDetails.setType(FailureType.JobFailed);
        failureDetails.setMessage(message);
        request.setFailureDetails(failureDetails);
        this.codePipelineClient.putJobFailureResult(request);
    }

    private String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        ListActionTypesRequest request = new ListActionTypesRequest();
        ListActionTypesResult actionTypes = this.codePipelineClient.listActionTypes(request);
        ArrayList<String> versionList = new ArrayList<String>();
        for (ActionType action : actionTypes.getActionTypes()) {
            ActionTypeId id = action.getId();
            if (!id.getCategory().equals("Deploy") || !id.getProvider().equals("XL-Deploy")) continue;
            versionList.add(id.getVersion());
        }
        this.validateVersion(versionList);
        this.version = (String)versionList.get(0);
        return this.version;
    }

    private void validateVersion(List<String> versions) {
        if (versions.size() == 0) {
            throw new CodePipelinePluginExecutionException("XL Deploy action is unavailable on CodePipeline");
        }
        if (versions.size() > 1) {
            throw new CodePipelinePluginExecutionException(String.format("Multiple versions %s of XL Deploy actions are configured on CodePipeline, only one version is expected", versions));
        }
    }

    private ActionTypeId getActionTypeId() {
        ActionTypeId actionTypeId = new ActionTypeId();
        actionTypeId.setCategory(ActionCategory.Deploy);
        actionTypeId.setOwner(ActionOwner.Custom);
        actionTypeId.setProvider("XL-Deploy");
        actionTypeId.setVersion(this.getVersion());
        return actionTypeId;
    }
}

