/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.services;

import com.amazonaws.util.Base64;
import com.thoughtworks.xstream.XStream;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.codepipeline.exceptions.CodePipelinePluginExecutionException;
import com.xebialabs.deployit.plugin.codepipeline.helpers.ConfigurationItemUtils;
import com.xebialabs.deployit.plugin.codepipeline.helpers.XldConfig;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLDeployService {
    private static final Logger logger = LoggerFactory.getLogger(XLDeployService.class);
    private final PackageService packageService;
    private final DeploymentService deploymentService;
    private final TaskBlockService taskBlockService;

    public XLDeployService(PackageService packageService, DeploymentService deploymentService, TaskBlockService taskBlockService) {
        this.packageService = packageService;
        this.deploymentService = deploymentService;
        this.taskBlockService = taskBlockService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationItem importPackage(Path filePath) {
        FileUpload fileUpload = new FileUpload();
        try (FileInputStream fileInputStream = new FileInputStream(filePath.toFile());){
            fileUpload.setFileData((InputStream)fileInputStream);
            ConfigurationItem configurationItem = this.packageService.upload(filePath.toFile().getAbsolutePath(), fileUpload);
            return configurationItem;
        }
        catch (IOException e) {
            throw new CodePipelinePluginExecutionException("Unable to import package from the S3 bucket", e);
        }
    }

    public Deployment prepareInitial(String packageId, String environment) {
        return this.deploymentService.prepareInitial(packageId, environment);
    }

    public Deployment prepareAutoMapping(Deployment deployment) {
        return this.deploymentService.prepareAutoDeployeds(deployment);
    }

    public String createTask(Deployment deployment, XldConfig xldConfig) {
        try {
            XStream xStream = XStreamReaderWriter.getConfiguredXStream();
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(String.format("%s/deployit/deployment", xldConfig.getXldUrl()));
            String baseEncoded = Base64.encodeAsString((byte[])String.format("%s:%s", xldConfig.getXldUsername(), xldConfig.getXldPassword()).getBytes());
            request.setHeader("Authorization", String.format("Basic %s", baseEncoded));
            request.setHeader("Content-Type", "application/xml");
            String deploymentXml = xStream.toXML((Object)deployment);
            StringEntity entity = new StringEntity(deploymentXml);
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)request);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String taskId = rd.readLine();
            return taskId;
        }
        catch (IOException e) {
            logger.error("Unable to create deployment task", (Throwable)e);
            return null;
        }
    }

    public TaskExecutionState startTaskAndWait(String taskId) {
        this.taskBlockService.start(taskId);
        TaskExecutionState taskState = this.taskBlockService.getTask(taskId).getState();
        while (taskState.isActive()) {
            taskState = this.taskBlockService.getTask(taskId).getState();
        }
        return taskState;
    }

    public boolean isInitialDeployment(String deploymentPackageId, String environmentId) {
        return !this.deploymentService.isDeployed(ConfigurationItemUtils.getParentId(deploymentPackageId), environmentId);
    }

    public Deployment updateDeployment(String deploymentPackageId, String environmentId) {
        String parentId = ConfigurationItemUtils.getParentId(deploymentPackageId);
        String deployedApplicationId = environmentId + "/" + ConfigurationItemUtils.getNameFromId(parentId);
        return this.deploymentService.prepareUpdate(deploymentPackageId, deployedApplicationId);
    }

    public Deployment validateDeployment(Deployment deployment) throws CodePipelinePluginExecutionException {
        Deployment validatedDeployment;
        block2: {
            validatedDeployment = null;
            try {
                logger.debug("validating deployment");
                validatedDeployment = this.deploymentService.validate(deployment);
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("The task did not deliver any steps")) break block2;
                throw new CodePipelinePluginExecutionException(e.getMessage(), e);
            }
        }
        return validatedDeployment;
    }

    public void archiveTask(String taskId) {
        this.taskBlockService.archive(taskId);
    }
}

