import base64
from dp import common, HttpRequest, HttpResponse

class SomaClient:

    __requestEnvelope = """<?xml version="1.0" encoding="UTF-8"?><soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><dp:request xmlns:dp="http://www.datapower.com/schemas/management" %s>%s</dp:request></soapenv:Body></soapenv:Envelope>"""
    __somaUrl         = "/service/mgmt/current"

    __setFile          = """<dp:set-file name="%s">%s</dp:set-file>"""
    __actionDeleteFile = """<dp:do-action><DeleteFile><File>%s</File></DeleteFile></dp:do-action>"""
    __actionSaveConfig = """<dp:do-action><SaveConfig/></dp:do-action>"""
    __actionImport     = """<dp:do-import source-type="%s" overwrite-files="%s" overwrite-objects="%s" deployment-policy="%s"><dp:input-file>%s</dp:input-file></dp:do-import>"""

    def __init__(self, address, port, username, password, verify = True):
        self.__request   = HttpRequest.HttpRequest(username, password, verify)
        self.__serverUrl = common.sanitizeUrl(address, port)
        
    
    def __doCall(self, command, domain = ''):

        if domain:
            domain = 'domain="%s"' % (domain)

        body = SomaClient.__requestEnvelope % (domain, command)
        requestUrl = self.__serverUrl + SomaClient.__somaUrl

        response = self.__request.post(requestUrl, body)
        response.ensureSuccessStatusCode()

        return response.getResponseXml()
    

    def uploadFile(self, domain, fileName, filePath):
        with open(filePath, 'rb') as f:
            encodedFile = base64.b64encode(f.read())

        request  = SomaClient.__setFile % (fileName, encodedFile.decode())

        return self.__doCall(request, domain)


    def deleteFile(self, domain, fileName):
        request  = SomaClient.__actionDeleteFile % (fileName)
        
        return self.__doCall(request, domain)


    def saveConfiguration(self, domain):
        return self.__doCall(SomaClient.__actionSaveConfig, domain)


    def importObject(self, domain, filePath, sourceType, overwriteFiles, overwriteObjects, deploymentPolicy):
        with open(filePath, 'rb') as f:
            encodedFile = base64.b64encode(f.read())

        request  = SomaClient.__actionImport % (sourceType, overwriteFiles, overwriteObjects, deploymentPolicy, encodedFile.decode())
        
        return self.__doCall(request, domain)
