package com.xebialabs.deployit.plugin.docker;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = DockerTLSValidator.Validator.class, type = "dockerTLSValidator")
@Target(ElementType.TYPE)
public @interface DockerTLSValidator {
    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<BaseContainer> {
        @Override
        public void validate(BaseContainer value, ValidationContext context) {
            boolean enableTls = Boolean.valueOf(value.getProperty("enableTLS").toString());
            String certPem = value.getProperty("certPem");
            String keyPem = value.getProperty("keyPem");
            String caPem = value.getProperty("caPem");
            if (enableTls && (isEmpty(certPem) || isEmpty(keyPem) || isEmpty(caPem)))
                context.error("When TLS is enabled, you must provide all certificates.", "" );
        }

        private boolean isEmpty(String key){
            if (key == null || key.trim().length() < 1){
                return true;
            }
            return false;
        }
    }
}
