#
from xlddocker import connect_to_docker
from xlddocker import print_docker_progress
from xlddocker import get_container_name
machine = deployed.container
dkr = connect_to_docker(machine)

image_tag_array = deployed.image.split(":")
image_name = image_tag_array[0]
image_tag = image_tag_array[1] if (len(image_tag_array) == 2) else 'latest'
print "Pulling ", image_name , " image with tag ", image_tag
print_docker_progress(dkr.pull(stream=True,repository=image_name,tag=image_tag))

print "Creating container", deployed.containerName, "from image", deployed.image

volumes = []
volumes_mount_point = []
for volume_name in deployed.volumes:
    volume = dkr.inspect_volume(volume_name)
    volumes.append(volume['Name']+":"+volume['Mountpoint'])
    volumes_mount_point.append(volume['Mountpoint'])

hostPorts = []
portBindings = {}
for portBinding in deployed.portBindings:

    protocol = portBinding.protocol
    if protocol != "tcp":
        hostPort = (portBinding.hostPort, str(protocol))
        portBindingKey = str(portBinding.containerPort) + "/" + str(protocol)
    else:
        hostPort = portBinding.hostPort
        portBindingKey = str(portBinding.containerPort)

    hostPorts.append(hostPort)
    portBindings[portBindingKey] = portBinding.hostPort

container_name = get_container_name(deployed, deployedApplication)

container = dkr.create_container(image=deployed.image, name=container_name, command=deployed.commands, ports=hostPorts,
                                 volumes=volumes_mount_point, detach=True,
                                 host_config=dkr.create_host_config(links=deployed.links,
                                                                    publish_all_ports=deployed.publishAllPorts,
                                                                    binds=volumes, port_bindings=portBindings))
containerId = container['Id']

if containerId:
    deployed.containerName = container_name

print "Created container with ID", containerId
