import socket
try:
    socket.SOL_TCP # if socket.SOL_TCP does not exist then jython will raise an AttributeError
except AttributeError , ae:
    socket.SOL_TCP = 6 # workaround for missing var in jython import

import docker
import json
import sys
import tempfile
import tarfile, io

import requests.packages.urllib3
requests.packages.urllib3.disable_warnings()

def create_temp_cert_file(contents):
    temp = tempfile.NamedTemporaryFile(delete=False)
    temp.write(contents)
    temp.seek(0)
    return temp

def connect_to_docker(host):
    print "Connecting to Docker host", host['dockerHost'], " "

    base_url = host['dockerHost']
    if base_url.startswith("tcp://"):
        if host['enableTLS']:
            base_url = "https://" + base_url[6:]
        else:
            base_url = "http://" + base_url[6:]

    if host['enableTLS']:
        certpem = create_temp_cert_file(host['certPem'])
        keypem = create_temp_cert_file(host['keyPem'])
        capem = create_temp_cert_file(host['caPem'])

        tls_config = docker.tls.TLSConfig(
                client_cert=(certpem.name, keypem.name),
                verify=capem.name,
                assert_hostname=False
        )
        client = docker.DockerClient(base_url=base_url, tls=tls_config)
    else:
        client = docker.DockerClient(base_url=base_url)

    return client

def print_docker_progress(stream):
    status = ""
    for p in stream:
        pp = json.loads(p)
        if 'status' in pp:
            if pp['status'] != status:
                status = pp['status']
                if 'id' in pp:
                    print "%s: %s" % (pp['id'], status), " "
                else:
                    print status, " "
        elif 'error' in pp:
            print pp['error'], " "
            sys.exit(1)
        else:
            print p

def check_docker_response(response):
    print response, " "


def copy_artifact_on_docker_container(deployed, artifact_name):

    dkr = connect_to_docker(deployed.container)
    tarbytes = io.BytesIO()
    tar = tarfile.open(fileobj=tarbytes, mode='w')
    tar.add(deployed.file.path, arcname=artifact_name)
    tar.close()

    dkr.api.put_archive(deployed.targetContainer, deployed.targetPath, tarbytes.getvalue())

