﻿using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace NerdDinner.Helpers {

    public class PhoneValidator {

        static readonly IDictionary<string, Regex> countryRegex = new Dictionary<string, Regex> {
               { "USA", new Regex(@"^[2-9]\d{2}-\d{3}-\d{4}$")},
							 { "Afghanistan", null },
							 { "Akrotiri", null },
							 { "Albania", null },
							 { "Algeria", null },
							 { "American Samoa", null },
							 { "Andorra", null },
							 { "Angola", null },
							 { "Anguilla", null },
							 { "Antarctica", null },
							 { "Antigua and Barbuda", null },
							 { "Argentina", null },
							 { "Armenia", null },
							 { "Aruba", null },
							 { "Ashmore and Cartier Islands", null },
               { "Australia", new Regex(@"^\({0,1}0(2|3|7|8)\){0,1}(\ |-){0,1}[0-9]{4}(\ |-){0,1}[0-9]{4}$")},
							 { "Austria", null },
							 { "Azerbaijan", null },
							 { "Bahamas, The", null },
							 { "Bahrain", null },
							 { "Bangladesh", null },
							 { "Barbados", null },
							 { "Bassas da India", null },
							 { "Belarus", null },
							 { "Belgium", null },
							 { "Belize", null },
							 { "Benin", null },
							 { "Bermuda", null },
							 { "Bhutan", null },
							 { "Bolivia", null },
							 { "Bosnia and Herzegovina", null },
							 { "Botswana", null },
							 { "Bouvet Island", null },
               { "Brazil", new Regex(@"^([0-9]{2})?((\([0-9]{2})\)|[0-9]{2})?([0-9]{3}|[0-9]{4})(\-)?[0-9]{4}$")},
							 { "British Indian Ocean Territory", null },
							 { "British Virgin Islands", null },
							 { "Brunei", null },
							 { "Bulgaria", null },
							 { "Burkina Faso", null },
							 { "Burma", null },
							 { "Burundi", null },
							 { "Cambodia", null },
							 { "Cameroon", null },
               { "Canada", new Regex(@"^((\d[-. ]?)?((\(\d{3}\))|\d{3}))?[-. ]?\d{3}[-. ]?\d{4}$")},
							 { "Cape Verde", null },
							 { "Cayman Islands", null },
							 { "Central African Republic", null },
							 { "Chad", null },
							 { "Chile", null },
							 { "China", null },
							 { "Christmas Island", null },
							 { "Clipperton Island", null },
							 { "Cocos (Keeling) Islands", null },
							 { "Colombia", null },
							 { "Comoros", null },
							 { "Congo, Democratic Republic of the", null },
							 { "Congo, Republic of the", null },
							 { "Cook Islands", null },
							 { "Coral Sea Islands", null },
							 { "Costa Rica", null },
							 { "Cote dIvoire", null },
							 { "Croatia", null },
							 { "Cuba", null },
							 { "Cyprus", null },
							 { "Czech Republic", null },
							 { "Denmark", null },
							 { "Dhekelia", null },
							 { "Djibouti", null },
							 { "Dominica", null },
							 { "Dominican Republic", null },
							 { "Ecuador", null },
							 { "Egypt", null },
							 { "El Salvador", null },
							 { "Equatorial Guinea", null },
							 { "Eritrea", null },
							 { "Estonia", null },
							 { "Ethiopia", null },
							 { "Europa Island", null },
							 { "Falkland Islands (Islas Malvinas)", null },
							 { "Faroe Islands", null },
							 { "Fiji", null },
							 { "Finland", null },
							 { "France", null },
							 { "French Guiana", null },
							 { "French Polynesia", null },
							 { "French Southern and Antarctic Lands", null },
							 { "Gabon", null },
							 { "Gambia, The", null },
							 { "Gaza Strip", null },
							 { "Georgia", null },
							 { "Germany", null },
							 { "Ghana", null },
							 { "Gibraltar", null },
							 { "Glorioso Islands", null },
							 { "Greece", null },
							 { "Greenland", null },
							 { "Grenada", null },
							 { "Guadeloupe", null },
							 { "Guam", null },
							 { "Guatemala", null },
							 { "Guernsey", null },
							 { "Guinea", null },
							 { "Guinea-Bissau", null },
							 { "Guyana", null },
							 { "Haiti", null },
							 { "Heard Island and McDonald Islands", null },
							 { "Holy See (Vatican City)", null },
							 { "Honduras", null },
							 { "Hong Kong", null },
							 { "Hungary", null },
							 { "Iceland", null },
               { "India", new Regex(@"^0{0,1}[1-9]{1}[0-9]{2}[\s]{0,1}[\-]{0,1}[\s]{0,1}[1-9]{1}[0-9]{6}$")},
							 { "Indonesia", null },
							 { "Iran", null },
							 { "Iraq", null },
							 { "Ireland", null },
							 { "Isle of Man", null },
							 { "Israel", null },
               { "Italy", new Regex(@"^([+]39)?((38[{8,9}|0])|(34[{7-9}|0])|(36[6|8|0])|(33[{3-9}|0])|(32[{8,9}]))([\d]{7})$")},
							 { "Jamaica", null },
							 { "Jan Mayen", null },
							 { "Japan", null },
							 { "Jersey", null },
							 { "Jordan", null },
							 { "Juan de Nova Island", null },
							 { "Kazakhstan", null },
							 { "Kenya", null },
							 { "Kiribati", null },
							 { "Korea, North", null },
							 { "Korea, South", null },
							 { "Kuwait", null },
							 { "Kyrgyzstan", null },
							 { "Laos", null },
							 { "Latvia", null },
							 { "Lebanon", null },
							 { "Lesotho", null },
							 { "Liberia", null },
							 { "Libya", null },
							 { "Liechtenstein", null },
							 { "Lithuania", null },
							 { "Luxembourg", null },
							 { "Macau", null },
							 { "Macedonia", null },
							 { "Madagascar", null },
							 { "Malawi", null },
							 { "Malaysia", null },
							 { "Maldives", null },
							 { "Mali", null },
							 { "Malta", null },
							 { "Marshall Islands", null },
							 { "Martinique", null },
							 { "Mauritania", null },
							 { "Mauritius", null },
							 { "Mayotte", null },
               { "Mexico", new Regex(@"^\(\d{3}\) ?\d{3}( |-)?\d{4}|^\d{3}( |-)?\d{3}( |-)?\d{4}")},
							 { "Micronesia, Federated States of", null },
							 { "Moldova", null },
							 { "Monaco", null },
							 { "Mongolia", null },
							 { "Montserrat", null },
							 { "Morocco", null },
							 { "Mozambique", null },
							 { "Namibia", null },
							 { "Nauru", null },
							 { "Navassa Island", null },
							 { "Nepal", null },
               { "Netherlands", new Regex(@"(^\+[0-9]{2}|^\+[0-9]{2}\(0\)|^\(\+[0-9]{2}\)\(0\)|^00[0-9]{2}|^0)([0-9]{9}$|[0-9\-\s]{10}$)")},
							 { "Netherlands Antilles", null },
							 { "New Caledonia", null },
							 { "New Zealand", null },
							 { "Nicaragua", null },
							 { "Niger", null },
							 { "Nigeria", null },
							 { "Niue", null },
							 { "Norfolk Island", null },
							 { "Northern Mariana Islands", null },
							 { "Norway", null },
							 { "Oman", null },
							 { "Pakistan", null },
							 { "Palau", null },
							 { "Panama", null },
							 { "Papua New Guinea", null },
							 { "Paracel Islands", null },
							 { "Paraguay", null },
               { "Peru", new Regex(@"^([2-9])(\d{2})(-?|\040?)(\d{4})( ?|\040?)(\d{1,4}?|\040?)$")},
							 { "Philippines", null },
							 { "Pitcairn Islands", null },
							 { "Poland", null },
							 { "Portugal", null },
							 { "Puerto Rico", null },
							 { "Qatar", null },
							 { "Reunion", null },
							 { "Romania", null },
							 { "Russia", null },
							 { "Rwanda", null },
							 { "Saint Helena", null },
							 { "Saint Kitts and Nevis", null },
							 { "Saint Lucia", null },
							 { "Saint Pierre and Miquelon", null },
							 { "Saint Vincent and the Grenadines", null },
							 { "Samoa", null },
							 { "San Marino", null },
							 { "Sao Tome and Principe", null },
							 { "Saudi Arabia", null },
							 { "Senegal", null },
							 { "Serbia and Montenegro", null },
							 { "Seychelles", null },
							 { "Sierra Leone", null },
							 { "Singapore", null },
							 { "Slovakia", null },
							 { "Slovenia", null },
							 { "Solomon Islands", null },
							 { "Somalia", null },
               { "South Africa", new Regex(@"^((?:\+27|27)|0)(=72|82|73|83|74|84)(\d{7})$")},
               { "Spain", new Regex(@"^[0-9]{2,3}-? ?[0-9]{6,7}$")},
							 { "Spratly Islands", null },
							 { "Sri Lanka", null },
							 { "Sudan", null },
							 { "Suriname", null },
							 { "Svalbard", null },
							 { "Swaziland", null },
               { "Sweden", new Regex(@"^(([+]\d{2}[ ][1-9]\d{0,2}[ ])|([0]\d{1,3}[-]))((\d{2}([ ]\d{2}){2})|(\d{3}([ ]\d{3})*([ ]\d{2})+))$")},
							 { "Switzerland", null },
							 { "Syria", null },
							 { "Taiwan", null },
							 { "Tajikistan", null },
							 { "Tanzania", null },
							 { "Thailand", null },
							 { "Timor-Leste", null },
							 { "Togo", null },
							 { "Tokelau", null },
							 { "Tonga", null },
							 { "Trinidad and Tobago", null },
							 { "Tromelin Island", null },
							 { "Tunisia", null },
							 { "Turkey", null },
							 { "Turkmenistan", null },
							 { "Turks and Caicos Islands", null },
							 { "Tuvalu", null },
							 { "Uganda", null },
							 { "Ukraine", null },
							 { "United Arab Emirates", null },
               { "UK", new Regex(@"^((\(?0\d{4}\)?\s?\d{3}\s?\d{3})|(\(?0\d{3}\)?\s?\d{3}\s?\d{4})|(\(?0\d{2}\)?\s?\d{4}\s?\d{4}))(\s?\#(\d{4}|\d{3}))?$")},
							 { "Uruguay", null },
							 { "Uzbekistan", null },
							 { "Vanuatu", null },
							 { "Venezuela", null },
							 { "Vietnam", null },
							 { "Virgin Islands", null },
							 { "Wake Island", null },
							 { "Wallis and Futuna", null },
							 { "West Bank", null },
							 { "Western Sahara", null },
							 { "Yemen", null },
							 { "Zambia", null },
							 { "Zimbabwe", null }
        };

        public static bool IsValidNumber(string phoneNumber, string country) {
            if (country != null && countryRegex.ContainsKey(country))
                return countryRegex[country].IsMatch(phoneNumber);
            return false;
        }

        public static IEnumerable<string> Countries {
            get {
                return countryRegex.Keys;
            }
        }
    }
}
