veryLongSatelliteName = 'SatelliteWithVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVery' \
                        'VeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVery' \
                        'VeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryVeryLongName'

create_ci('Infrastructure/Satellite', 'core.Directory')

for i in range(1, 12):
    satelliteId = 'Infrastructure/Satellite/LocalSatellite' + str(i)
    create_ci(satelliteId, 'xl.Satellite', {'address': '127.0.0.1', 'protocolPort': '8380',
                                            'encrypted': 'false'})

    envId = 'Environments/EnvWithSatellite' + str(i)
    hostId = 'Infrastructure/satellite-host' + str(i)
    create_ci(hostId, 'overthere.SshHost',
              {
                  'address': 'localhost',
                  'connectionType': 'SUDO',
                  'os': 'UNIX',
                  'password': 'root',
                  'port': '12345',
                  'sudoUsername': 'root',
                  'username': 'root',
                  'satellite': satelliteId
              })

    create_ci(envId, 'udm.Environment',
              {'dictionaries': ['Environments/Defaults'],
               'members': [hostId]})

    for appVersion in range(1, 12):
        appId = 'Applications/SatelliteApp/' + str(appVersion) + '.0'
        create_initial_task(appId, envId, "admin", False)

    create_initial_task('Applications/AppForHistory/1.0', envId, "admin", False)
    create_initial_task('Applications/AppForHistory/2.0', envId, "admin", False)
    create_initial_task('Applications/AppForHistory/3.0', envId, "admin", False)
    create_initial_task('Applications/LongRunningApp/1.0', envId, "admin", False)
    create_initial_task('Applications/TestApp/1.0', envId, "admin", False)
    create_initial_task('Applications/AppForUpdateScenario/1.0', envId, "admin", False)
    create_initial_task('Applications/AppForUpdateScenario/2.0', envId, "admin", False)
    create_initial_task('Applications/AppForUpdateScenario/3.0', envId, "admin", False)
    create_initial_task('Applications/MultiCommandApp/1.0', envId, "admin", False)

create_ci('Infrastructure/Satellite/MisconfiguredSatellite', 'xl.Satellite',
          {'address': '127.0.0.1', 'protocolPort': '9999',
           'encrypted': 'false'})

create_ci('Infrastructure/Satellite/' + veryLongSatelliteName, 'xl.Satellite',
          {'address': '127.0.0.1', 'protocolPort': '8380',
           'encrypted': 'false'})
create_ci('Infrastructure/Satellite/XLSatelliteGroup', 'xl.SatelliteGroup',
          {'satellites': ['Infrastructure/Satellite/LocalSatellite1',
                          'Infrastructure/Satellite/LocalSatellite2',
                          'Infrastructure/Satellite/LocalSatellite3',
                          'Infrastructure/Satellite/LocalSatellite4',
                          'Infrastructure/Satellite/LocalSatellite5',
                          'Infrastructure/Satellite/LocalSatellite6',
                          'Infrastructure/Satellite/LocalSatellite7',
                          'Infrastructure/Satellite/LocalSatellite8',
                          'Infrastructure/Satellite/LocalSatellite9',
                          'Infrastructure/Satellite/LocalSatellite10',
                          'Infrastructure/Satellite/LocalSatellite11',
                          'Infrastructure/Satellite/' + veryLongSatelliteName,
                          'Infrastructure/Satellite/MisconfiguredSatellite']})

create_ci('Infrastructure/Satellite/LocalSatelliteGroup', 'xl.SatelliteGroup',
          {'satellites': ['Infrastructure/Satellite/LocalSatellite1',
                          'Infrastructure/Satellite/LocalSatellite2']})

create_ci('Infrastructure/group-host', 'overthere.SshHost',
          {
              'address': 'localhost',
              'connectionType': 'SUDO',
              'os': 'UNIX',
              'password': 'root',
              'port': '12345',
              'sudoUsername': 'root',
              'username': 'root',
              'satellite': 'Infrastructure/Satellite/LocalSatelliteGroup'
          })

create_ci('Environments/Group', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'],
           'members': ['Infrastructure/group-host']})
create_ci('Infrastructure/Satellite/MultiHostedSatelliteGroup', 'xl.SatelliteGroup',
          {'satellites': ['Infrastructure/Satellite/LocalSatellite1']})

create_ci('Infrastructure/Satellite/SatelliteGroupTeam', 'core.Directory')

for i in range(1, 15):
    create_ci('Infrastructure/Satellite/SatelliteGroupTeam/groupTeam-host-' + str(i),
              'overthere.SshHost',
              {
                  'address': 'localhost',
                  'connectionType': 'SUDO',
                  'os': 'UNIX',
                  'password': 'root',
                  'port': '12345',
                  'sudoUsername': 'root',
                  'username': 'root',
                  'satellite': 'Infrastructure/Satellite/MultiHostedSatelliteGroup'
              })

multiHostedSatelliteId = 'Infrastructure/Satellite/MultiHostedSatellite'
create_ci(multiHostedSatelliteId, 'xl.Satellite',
          {'address': '127.0.0.1', 'protocolPort': '8380',
           'encrypted': 'false'})

for teamLetter in ['A', 'B', 'C', 'D']:
    teamId = 'Infrastructure/Satellite/Team' + teamLetter
    create_ci(teamId, 'core.Directory')
    for i in range(1, 10):
        create_ci(teamId + '/team-' + teamLetter + '-host-' + str(i),
                  'overthere.SshHost',
                  {
                      'address': 'localhost',
                      'connectionType': 'SUDO',
                      'os': 'UNIX',
                      'password': 'root',
                      'port': '12345',
                      'sudoUsername': 'root',
                      'username': 'root',
                      'satellite': multiHostedSatelliteId
                  })

grant_permissions("read", "Cis_reader_only", ['Infrastructure/Satellite'])
grant_permissions("read", "Cis_reader_only", ['Infrastructure/Satellite/TeamA'])
grant_permissions("read", "Cis_reader_only", ['Infrastructure/Satellite/SatelliteGroupTeam'])
grant_permissions("read", "Task_View_Only", ['Infrastructure/Satellite'])

grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/TeamB'])
grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/TeamC'])
grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/TeamD'])
grant_permissions("controltask#execute", "Cis_reader_only", ['Infrastructure/Satellite/SatelliteGroupTeam'])


def update_jboss_host(ci):
    ci.satellite = 'Infrastructure/Satellite/LocalSatellite1'


update_ci('Infrastructure/jboss-host', update_jboss_host)

create_ci('Environments/EnvWithSatelliteGroup', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'],
           'members': ['Infrastructure/host6']})

for appVersion in range(1, 12):
    appId = 'Applications/SatelliteApp/' + str(appVersion) + '.0'
    create_initial_task(appId, 'Environments/EnvWithSatelliteGroup', "admin", False)

# Create explorer.Satellite cis
for i in range(1, 2):
    satellite = 'Infrastructure/Satellite/ExpSatellite' + str(i)
    create_ci(
        satellite,
        'explorer.Satellite',
        {
            'address': '127.0.0.1',
            'protocolPort': '8380',
            'encrypted': 'false'
        }
    )

# Create explorer.SatelliteGroup cis
for i in range(1, 2):
    satellite = 'Infrastructure/Satellite/ExpSatelliteGroup' + str(i)
    create_ci(satellite, 'explorer.SatelliteGroup')
