import json

create_ci('Applications/JsonPatch', 'core.Directory')
create_ci('Environments/JsonPatch', 'core.Directory')
create_ci('Infrastructure/JsonPatch', 'core.Directory')

import_package('JsonPatchApplication-1.0.dar')
move_ci('Applications/JsonPatchApplication', 'Applications/JsonPatch/JsonPatchApplication')

create_default_ssh_host('Infrastructure/JsonPatch/JsonPatchContainer')
create_ci('Infrastructure/JsonPatch/JsonPatchContainer/JsonPatchYakBucket', 'yak.Bucket')
create_ci('Infrastructure/JsonPatch/JsonPatchContainer/JsonPatchNameSpace', 'yak.NameSpace')
create_ci('Infrastructure/JsonPatch/JsonPatchContainer/JsonPatchYakServer', 'yak.YakServer')

create_ci('Environments/JsonPatch/KubernetesJsonPatchDictionary', 'patch.JsonPatchDictionary', {
    'activators': json.dumps([{'path': '/metadata/name', 'cond': 'equals', 'value': 'gp2'}]),
    'name': 'patchDictionary1',
    'packages': ['Applications/KubernetesApp/1.0'],
    'patches': json.dumps([{'op': 'replace', 'path': '/mountOptions/0', 'value': 'production'}])
})

create_ci('Environments/JsonPatch/DefaultJsonPatchDictionary', 'patch.JsonPatchDictionary', {
    'activators': json.dumps([{'path': '/baz', 'cond': 'equals', 'value': 'qux'}]),
    'name': 'patchDictionary1',
    'packages': ['Applications/JsonPatch/JsonPatchApplication/1.0'],
    'patches': json.dumps([{'op': 'replace', 'path': '/foo', 'value': 'replaced-bar'}])
})

create_ci('Environments/JsonPatch/JsonPatchEnvironment', 'udm.Environment', {
    'dictionaries': ['Environments/Defaults'],
    'members': [
        'Infrastructure/JsonPatch/JsonPatchContainer/JsonPatchYakServer',
        'Infrastructure/kubernetes-host'
    ],
    'patchDictionaries': [
        'Environments/JsonPatch/DefaultJsonPatchDictionary',
        'Environments/JsonPatch/KubernetesJsonPatchDictionary'
    ]
})

activators = [{"path": "/users/0/name", "cond": "equals", "value": "admin"}, {"path": "/volumes/eks", "cond": "exists"}] + map(lambda x: {"path": "/permissionIds/%s" %x, "cond": "equals", "value": str(x)}, range(0, 311))
patches = [{"op": "add", "path": "/users/1/disabled", "value": "true"}, {"op": "remove", "path": "/users/1/disabled"}] + map(lambda x: {"op": "replace", "path": "/users/%s/id" %x, "value": str(x)}, range(0, 35))

create_ci('Environments/JsonPatch/patchDictionary1', 'patch.JsonPatchDictionary', {
    'name': 'patchDictionary1',
    'customSample': """{
    "users": [
        {"name": "admin"},
        {"name": "john"},
        {"name": "jack", "disabled": "true"}
    ],
    "permissionIds": [1, 5, 3, 11],
    "volumes": {
        "eks": "true"
    }
}""",
    'sourceType': 'Custom',
    'activators': json.dumps(activators),
    'patches': json.dumps(patches)
})
