#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.cronjob.cronjob_helper import CronJobHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(previousDeployed.container).create()
cronjob_name = CronJobHelper().get_cronjob_name(previousDeployed)


context.addStepWithCheckpoint(steps.jython(
    description="Destroy CronJob {0} from {1}".format(cronjob_name, container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/cronjob/remove_cronjob.py",
    order=previousDeployed.destroyOrder
), delta)

context.addStep(steps.jython(
    description="Wait for CronJob {0} to be destroyed completely".format(cronjob_name),
    script="xld/kubernetes/cronjob/wait_for_destroy.py",
    order=previousDeployed.destroyOrder
))
